/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.descriptor;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.project.template.descriptor.ConfigTemplateParser;
import com.atlassian.jira.project.template.descriptor.DefaultPluginParseHelper;
import com.atlassian.jira.project.template.descriptor.PluginParseHelper;
import com.atlassian.jira.project.template.descriptor.ResourceDescriptorFactory;
import com.atlassian.jira.project.template.hook.AddProjectModule;
import com.atlassian.jira.project.template.module.AddProjectModuleBuilder;
import com.atlassian.jira.project.template.module.Icon;
import com.atlassian.jira.project.template.module.ProjectTemplateModule;
import com.atlassian.jira.project.template.module.ProjectTemplateModuleBuilder;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class ProjectTemplateModuleDescriptor
extends AbstractModuleDescriptor<ProjectTemplateModule>
implements ConditionalDescriptor {
    private final ConfigTemplateParser configTemplateParser;
    private final WebResourceUrlProvider urlProvider;
    private final ResourceDescriptorFactory resourceDescriptorFactory;
    private final WebInterfaceManager webInterfaceManager;
    private final ConditionElementParser conditionElementParser;
    private Element element;
    private Condition condition;
    @ClusterSafe(value="Plugins are kept in synch across the cluster")
    private final ResettableLazyReference<ProjectTemplateModule> module = new ResettableLazyReference<ProjectTemplateModule>(){

        protected ProjectTemplateModule create() {
            return ProjectTemplateModuleDescriptor.this.createModuleFromXml(ProjectTemplateModuleDescriptor.this.element);
        }
    };

    public ProjectTemplateModuleDescriptor(ModuleFactory moduleFactory, WebResourceUrlProvider urlProvider, ResourceDescriptorFactory resourceDescriptorFactory, WebInterfaceManager webInterfaceManager, ConfigTemplateParser configTemplateParser) {
        this(moduleFactory, urlProvider, resourceDescriptorFactory, webInterfaceManager, null, configTemplateParser);
    }

    @VisibleForTesting
    public ProjectTemplateModuleDescriptor(ModuleFactory moduleFactory, WebResourceUrlProvider urlProvider, ResourceDescriptorFactory resourceDescriptorFactory, WebInterfaceManager webInterfaceManager, ConditionElementParser.ConditionFactory conditionFactory, ConfigTemplateParser configTemplateParser) {
        super(moduleFactory);
        this.urlProvider = urlProvider;
        this.resourceDescriptorFactory = resourceDescriptorFactory;
        this.webInterfaceManager = webInterfaceManager;
        this.configTemplateParser = configTemplateParser;
        this.conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)(conditionFactory != null ? conditionFactory : new TemplateConditionFactory()));
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
    }

    public void enabled() {
        super.enabled();
        this.condition = this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
        this.module.reset();
    }

    public void disabled() {
        super.disabled();
        this.module.reset();
    }

    public ProjectTemplateModule getModule() {
        return (ProjectTemplateModule)this.module.get();
    }

    @Nonnull
    public Condition getCondition() {
        return this.condition != null ? this.condition : new AlwaysDisplayCondition();
    }

    public void addResource(String path, String name) {
        try {
            ResourceDescriptor resource = this.resourceDescriptorFactory.createResource(this.plugin, name, path);
            this.addToResources(resource);
        }
        catch (FileNotFoundException e) {
            throw new PluginException(String.format("File for '%s' does not exist at location: %s", name, path));
        }
    }

    private ProjectTemplateModule createModuleFromXml(Element element) {
        DefaultPluginParseHelper template = new DefaultPluginParseHelper(element, "//project-blueprint[@key='" + element.attribute("key").getValue() + "']");
        ProjectTemplateModuleBuilder builder = new ProjectTemplateModuleBuilder();
        String weight = template.optAttribute("weight");
        return builder.key(this.getPluginKey() + ":" + template.attribute("key")).weight(weight != null ? Integer.valueOf(weight) : 100).labelKey(template.element("label").attribute("key")).descriptionKey(template.element("description").attribute("key")).longDescriptionKey(template.element("longDescription").attribute("key")).icon(this.createIconFor(template, "icon")).backgroundIcon(this.createIconFor(template, "backgroundIcon")).infoSoyPath(template.optElement("infoPage").orElse(PluginParseHelper.NULL_PARSE_HELPER).attribute("soy-template")).addProjectModule(this.createAddProjectModuleForTemplateElement(template)).projectTypeKey(template.element("projectTypeKey").text()).build();
    }

    private AddProjectModule createAddProjectModuleForTemplateElement(PluginParseHelper template) {
        Optional<PluginParseHelper> addProjectElement = template.optElement("add-project");
        AddProjectModule addProjectModule = null;
        if (addProjectElement.isPresent()) {
            AddProjectModuleBuilder addProjectModuleBuilder = this.getProjectTemplateModuleBuilder();
            addProjectModule = addProjectModuleBuilder.addProjectHookClassName(this.checkClassExists(addProjectElement.get().optElement("hook").orElse(PluginParseHelper.NULL_PARSE_HELPER).attribute("class"))).templateConfigurationFile(addProjectElement.get().optElement("descriptor").orElse(PluginParseHelper.NULL_PARSE_HELPER).attribute("file")).build();
        }
        return addProjectModule;
    }

    private Icon createIconFor(PluginParseHelper template, String elementName) {
        Optional<PluginParseHelper> iconElement = template.optElement(elementName);
        String location = iconElement.orElse(PluginParseHelper.NULL_PARSE_HELPER).attribute("location");
        if (StringUtils.isBlank((CharSequence)location)) {
            return new Icon();
        }
        String resourceName = elementName + this.getFileExtension(location);
        try {
            ResourceDescriptor resource = this.resourceDescriptorFactory.createResource(this.plugin, resourceName, location);
            this.addToResources(resource);
            return new Icon(this.urlProvider, location, this.getCompleteKey(), resource.getName());
        }
        catch (FileNotFoundException e) {
            throw new PluginException(String.format("Icon file for '%s' does not exist at location: %s", elementName, location));
        }
    }

    private String getFileExtension(String path) {
        int indexOfDot;
        int n = indexOfDot = path != null ? path.lastIndexOf(46) : -1;
        if (indexOfDot != -1) {
            return path.substring(indexOfDot);
        }
        return "";
    }

    private void addToResources(ResourceDescriptor resource) {
        ImmutableList build = ImmutableList.builder().addAll((Iterable)this.resources.getResourceDescriptors()).add((Object)resource).build();
        this.resources = new Resources((Iterable)build);
    }

    private String checkClassExists(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        try {
            this.getPlugin().loadClass(className, ((Object)((Object)this)).getClass());
            return className;
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Class '" + className + "' not found.", (Throwable)e);
        }
    }

    protected AddProjectModuleBuilder getProjectTemplateModuleBuilder() {
        return new AddProjectModuleBuilder(this.configTemplateParser, this.moduleFactory, this);
    }

    private class TemplateConditionFactory
    implements ConditionElementParser.ConditionFactory {
        private TemplateConditionFactory() {
        }

        public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
            return ProjectTemplateModuleDescriptor.this.webInterfaceManager.getWebFragmentHelper().loadCondition(className, plugin);
        }
    }
}

