/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.util.Named;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectCache.class);
    private final OfBizDelegator delegator = ComponentAccessor.getOfBizDelegator();
    private final ProjectManager projectManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final ProjectKeyStore projectKeyStore;
    private volatile ImmutableMap<Long, Project> projectsById;
    private volatile ImmutableMap<String, Project> projectsByCurrentKey;
    private volatile ImmutableSortedMap<String, Project> projectsByCurrentKeyIgnoreCase;
    private volatile ImmutableMap<Long, ProjectCategory> projectCategories;
    private volatile ImmutableMap<Long, Long> projectIdToProjectCategoryId;
    private volatile ImmutableMap<Long, List<Long>> projectCategoriesToProjects;
    private volatile ImmutableList<Long> projectsWithNoCategory;
    private volatile ImmutableList<Project> allProjectObjects;

    public ProjectCache(ProjectManager projectManager, ProjectKeyStore projectKeyStore, NodeAssociationStore nodeAssociationStore) {
        this.projectManager = projectManager;
        this.projectKeyStore = projectKeyStore;
        this.nodeAssociationStore = nodeAssociationStore;
        this.init();
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProjectCache.refresh");
        }
        long start = System.currentTimeMillis();
        UtilTimerStack.push((String)"ProjectCache.refresh");
        try {
            this.refreshProjectList();
            this.refreshProjectCategories();
            this.refreshCategoryProjectMappings((Map<Long, Project>)this.projectsById);
            this.refreshProjectsWithNoCategory();
        }
        finally {
            UtilTimerStack.pop((String)"ProjectCache.refresh");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProjectCache.refresh took " + (System.currentTimeMillis() - start));
        }
    }

    private void refreshProjectList() {
        List dbProjects = this.projectManager.getProjectObjects();
        LinkedHashMap tmpById = Maps.newLinkedHashMap();
        LinkedHashMap tmpByCurrentKey = Maps.newLinkedHashMap();
        for (Project project : dbProjects) {
            tmpById.put(project.getId(), project);
            tmpByCurrentKey.put(project.getKey(), project);
        }
        this.projectsById = ImmutableMap.copyOf((Map)tmpById);
        this.projectsByCurrentKey = ImmutableMap.copyOf((Map)tmpByCurrentKey);
        this.projectsByCurrentKeyIgnoreCase = ImmutableSortedMap.copyOf(this.projectsByCurrentKey, (Comparator)String.CASE_INSENSITIVE_ORDER);
        this.allProjectObjects = ImmutableList.copyOf((Collection)dbProjects);
    }

    protected void refreshProjectCategories() {
        List dbCategories = this.delegator.findAll("ProjectCategory");
        Collections.sort(dbCategories, OfBizComparators.NAME_COMPARATOR);
        LinkedHashMap tmpById = new LinkedHashMap(dbCategories.size() * 2);
        for (GenericValue projectCategory : dbCategories) {
            tmpById.put(projectCategory.getLong("id"), Entity.PROJECT_CATEGORY.build(projectCategory));
        }
        this.projectCategories = ImmutableMap.copyOf(tmpById);
    }

    public Project getProject(Long id) {
        return (Project)this.projectsById.get((Object)id);
    }

    @Nullable
    public Project getProjectByName(String name) {
        for (Project project : this.getProjects()) {
            if (!project.getName().equalsIgnoreCase(name)) continue;
            return project;
        }
        return null;
    }

    @Nullable
    public Project getProjectByKey(String key) {
        Long projectId = this.projectKeyStore.getProjectId(key);
        return projectId != null ? this.getProject(projectId) : null;
    }

    public Collection<Project> getProjects() {
        return this.projectsById.values();
    }

    public List<Project> getProjectObjects() {
        return this.allProjectObjects;
    }

    public Collection<ProjectCategory> getProjectCategories() {
        return this.projectCategories.values();
    }

    @Nullable
    public ProjectCategory getProjectCategory(Long id) {
        return (ProjectCategory)this.projectCategories.get((Object)id);
    }

    private void refreshCategoryProjectMappings(Map<Long, Project> projectsById) {
        Collection<ProjectCategory> categories = this.getProjectCategories();
        HashMap tmpProjectCategoriesToProjects = Maps.newHashMapWithExpectedSize((int)categories.size());
        HashMap<Long, Long> tmpProjectIdToProjectCategoryId = new HashMap<Long, Long>(64);
        for (ProjectCategory category : categories) {
            try {
                List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(NodeAssocationType.PROJECT_TO_CATEGORY, category.getId());
                ArrayList sortedProjectIds = new ArrayList(projectIds.size());
                projectIds.stream().map(projectsById::get).sorted(Named.NAME_COMPARATOR).forEach(project -> sortedProjectIds.add(project.getId()));
                tmpProjectCategoriesToProjects.put(category.getId(), sortedProjectIds);
                for (Long projectId : projectIds) {
                    tmpProjectIdToProjectCategoryId.put(projectId, category.getId());
                }
            }
            catch (DataAccessException ex) {
                LOG.error("Error getting projects for category " + category + ": " + (Object)((Object)ex), (Throwable)ex);
            }
        }
        this.projectIdToProjectCategoryId = ImmutableMap.copyOf(tmpProjectIdToProjectCategoryId);
        this.projectCategoriesToProjects = ImmutableMap.copyOf((Map)tmpProjectCategoriesToProjects);
    }

    private static List<Long> getIdsFromProjects(Collection<Project> projectObjects) {
        if (projectObjects == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Iterables.transform(projectObjects, (Function)new Function<Project, Long>(){

            @Nullable
            public Long apply(@Nullable Project project) {
                return project != null ? project.getId() : null;
            }
        }));
    }

    private List<Project> getProjectsFromProjectIds(Collection<Long> projectIds) {
        if (projectIds == null) {
            return Collections.emptyList();
        }
        return (List)projectIds.stream().map(this::getProject).collect(CollectorsUtil.toNewArrayListWithSizeOf(projectIds));
    }

    public Collection<Project> getProjectsFromProjectCategory(Long projectCategoryId) {
        List projectIds;
        if (projectCategoryId != null && (projectIds = (List)this.projectCategoriesToProjects.get((Object)projectCategoryId)) != null) {
            return this.getProjectsFromProjectIds(projectIds);
        }
        return Collections.emptyList();
    }

    @Nullable
    public ProjectCategory getProjectCategoryForProject(Project project) {
        return project != null ? this.getProjectCategoryForProjectId(project.getId()) : null;
    }

    @Nullable
    public ProjectCategory getProjectCategoryFromProject(Project project) {
        return project != null ? this.getProjectCategoryForProjectId(project.getId()) : null;
    }

    @Nullable
    private ProjectCategory getProjectCategoryForProjectId(Long projectId) {
        Long projectCategoryId = (Long)this.projectIdToProjectCategoryId.get((Object)projectId);
        return projectCategoryId != null ? this.getProjectCategory(projectCategoryId) : null;
    }

    public Collection<Project> getProjectsWithNoCategory() {
        return this.getProjectsFromProjectIds((Collection<Long>)this.projectsWithNoCategory);
    }

    protected void refreshProjectsWithNoCategory() {
        Collection<Project> projects = this.getProjects();
        ArrayList projectObjectsWithNoCategory = Lists.newArrayListWithCapacity((int)projects.size());
        projectObjectsWithNoCategory.addAll(projects.stream().filter(project -> this.getProjectCategoryFromProject((Project)project) == null).collect(Collectors.toList()));
        Collections.sort(projectObjectsWithNoCategory, Named.NAME_COMPARATOR);
        this.projectsWithNoCategory = ImmutableList.copyOf(ProjectCache.getIdsFromProjects(projectObjectsWithNoCategory));
    }

    public Project getProjectByCurrentKeyIgnoreCase(String projectKey) {
        return (Project)this.projectsByCurrentKeyIgnoreCase.get((Object)projectKey);
    }

    @Nullable
    public Project getProjectByKeyIgnoreCase(String projectKey) {
        Long projectId = this.projectKeyStore.getProjectIdByKeyIgnoreCase(projectKey);
        return projectId != null ? this.getProject(projectId) : null;
    }

    public Project getProjectByCurrentKey(String projectKey) {
        return (Project)this.projectsByCurrentKey.get((Object)projectKey);
    }

    public Set<String> getAllProjectKeys(Long projectId) {
        return this.projectKeyStore.getProjectKeys(projectId);
    }
}

