/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.plugin.ModuleCompleteKey;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PortletConfigurationImpl
implements PortletConfiguration {
    private final Long id;
    private Long dashboardPageId;
    private Integer column;
    private Integer row;
    private Color color;
    private Map<String, String> userPrefs;
    private final Option<URI> openSocialSpecUri;
    private final Option<ModuleCompleteKey> completeModuleKey;

    public PortletConfigurationImpl(Long id, Long dashboardPageId, Integer column, Integer row, Option<URI> openSocialSpecUri, Color color, Map<String, String> userPrefs, Option<ModuleCompleteKey> completeModuleKey) {
        this.id = id;
        this.dashboardPageId = dashboardPageId;
        this.column = column;
        this.row = row;
        this.openSocialSpecUri = openSocialSpecUri;
        this.completeModuleKey = completeModuleKey;
        this.color = color == null ? Color.color1 : color;
        this.userPrefs = Collections.unmodifiableMap(new HashMap<String, String>(userPrefs));
    }

    public Long getId() {
        return this.id;
    }

    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public Integer getRow() {
        return this.row;
    }

    public Long getDashboardPageId() {
        return this.dashboardPageId;
    }

    public void setDashboardPageId(Long dashboardPageId) {
        this.dashboardPageId = dashboardPageId;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public URI getGadgetURI() {
        return (URI)this.openSocialSpecUri.getOrNull();
    }

    public Map<String, String> getUserPrefs() {
        return this.userPrefs;
    }

    public void setUserPrefs(Map<String, String> userPrefs) {
        this.userPrefs = new HashMap<String, String>(userPrefs);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Option<ModuleCompleteKey> getCompleteModuleKey() {
        return this.completeModuleKey;
    }

    public Option<URI> getOpenSocialSpecUri() {
        return this.openSocialSpecUri;
    }

    public int compareTo(PortletConfiguration that) {
        return this.getRow().compareTo(that.getRow());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

