/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class JiraWebResourceBatchingConfiguration
implements ResourceBatchingConfiguration {
    public static final String PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING = "plugin.webresource.batch.content.tracking".toString();
    private static final String PLUGIN_WEB_RESOURCE_BATCH_CONTEXT_ALWAYS_RESPLIT_FEATURE_KEY = "plugin.webresource.batch.context.always.resplit";
    private static final String USER_AGENT = "USER-AGENT";
    private final List<String> resources;
    private final JiraProperties jiraSystemProperties;
    private final FeatureManager featureManager;

    public JiraWebResourceBatchingConfiguration(JiraProperties jiraSystemProperties, FeatureManager featureManager) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.featureManager = featureManager;
        ImmutableList.Builder resourcesBuilder = ImmutableList.builder().add((Object)"jira.webresources:superbatch-default");
        if (featureManager.isEnabled("plugin.webresource.batch.timezone")) {
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-tzdetect-plugin:tzdetect-lib");
        }
        if (featureManager.isEnabled("APDEX-218")) {
            resourcesBuilder.add((Object)"com.atlassian.applinks.applinks-plugin:applinks-public");
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-quick-edit-plugin:quick-edit-issue");
            resourcesBuilder.add((Object)"com.atlassian.auiplugin:aui-alignment");
            resourcesBuilder.add((Object)"com.atlassian.auiplugin:aui-help");
            resourcesBuilder.add((Object)"com.atlassian.auiplugin:dialog2");
            resourcesBuilder.add((Object)"com.atlassian.auiplugin:ajs-raf");
            resourcesBuilder.add((Object)"com.atlassian.plugins.helptips.jira-help-tips:common");
            resourcesBuilder.add((Object)"com.atlassian.auiplugin:aui-inline-dialog2");
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-share-plugin:share-resources");
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-share-plugin:share-resources-init");
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-view-issue-plugin:soy-templates");
            resourcesBuilder.add((Object)"com.atlassian.plugins.browser.metrics.browser-metrics-plugin:api");
            resourcesBuilder.add((Object)"jira.webresources:jqlautocomplete");
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-projects-plugin:browser-util");
            resourcesBuilder.add((Object)"com.atlassian.plugins.atlassian-plugins-webresource-rest:curl");
            resourcesBuilder.add((Object)"com.atlassian.pocketknife.featureflags-plugin:pocketknife-feature-flags");
            resourcesBuilder.add((Object)"com.atlassian.plugins.atlassian-plugins-webresource-rest:web-resource-manager");
            resourcesBuilder.add((Object)"com.atlassian.servicedesk:cv-sd-shared");
            resourcesBuilder.add((Object)"com.atlassian.servicedesk:sd-request-type-selector");
            resourcesBuilder.add((Object)"com.atlassian.servicedesk:sd-sla-simple-view-resource");
            resourcesBuilder.add((Object)"com.atlassian.servicedesk:servicedesk-global");
            resourcesBuilder.add((Object)"is.origo.jira.tempo-plugin:tempo-global");
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-projects-plugin:sidebar-switch-analytics");
            resourcesBuilder.add((Object)"com.pyxis.greenhopper.jira:gh-analytics-tracker");
        }
        this.resources = resourcesBuilder.build();
    }

    public boolean isSuperBatchingEnabled() {
        return !this.resources.isEmpty() && !this.jiraSystemProperties.isSuperBatchingDisabled() || this.forceBatchingInThisRequest();
    }

    public boolean isContextBatchingEnabled() {
        return !this.jiraSystemProperties.isDevMode() || this.forceBatchingInThisRequest();
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        boolean forced = this.forceBatchingInThisRequest();
        if (forced) {
            return true;
        }
        if (this.jiraSystemProperties.getProperty("plugin.webresource.batching.off") != null) {
            return !Boolean.parseBoolean(this.jiraSystemProperties.getProperty("plugin.webresource.batching.off"));
        }
        return !this.jiraSystemProperties.isDevMode();
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return this.resources;
    }

    public boolean isJavaScriptTryCatchWrappingEnabled() {
        return this.jiraSystemProperties.getBoolean("plugin.webresource.javascript.try.catch.wrapping");
    }

    public boolean isBatchContentTrackingEnabled() {
        return this.jiraSystemProperties.getBoolean(PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING);
    }

    public boolean resplitMergedContextBatchesForThisRequest() {
        return this.featureManager.isEnabled(PLUGIN_WEB_RESOURCE_BATCH_CONTEXT_ALWAYS_RESPLIT_FEATURE_KEY) || this.isCurrentRequestIE();
    }

    public boolean isSourceMapEnabled() {
        return false;
    }

    private boolean forceBatchingInThisRequest() {
        return this.jiraSystemProperties.isDevMode() && this.isCurrentRequestIE();
    }

    private boolean isCurrentRequestIE() {
        HttpServletRequest httpRequest = ExecutingHttpRequest.get();
        if (httpRequest == null) {
            return false;
        }
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        String userAgent = httpRequest.getHeader(USER_AGENT);
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        return userAgentInfo.getBrowser().getBrowserFamily().equals((Object)UserAgentUtil.BrowserFamily.MSIE) || userAgentInfo.getBrowser().getBrowserFamily().equals((Object)UserAgentUtil.BrowserFamily.IE);
    }
}

