/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.model;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CommentHelper
extends JiraHelper {
    private final Option<Issue> issue;
    private final Option<Comment> comment;

    public CommentHelper(HttpServletRequest request, Project project, Option<Issue> issue, Option<Comment> comment) {
        super(request, project);
        this.issue = issue;
        this.comment = comment;
    }

    public Map<String, Object> getContextParams() {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.getContextParams());
        this.issue.foreach((Effect)new Effect<Issue>(){

            public void apply(Issue issue) {
                builder.put((Object)"issue", (Object)issue);
            }
        });
        this.comment.foreach((Effect)new Effect<Comment>(){

            public void apply(Comment comment) {
                builder.put((Object)"comment", (Object)comment);
            }
        });
        return builder.build();
    }

    public static CommentHelperBuilder builder() {
        return new CommentHelperBuilder();
    }

    public static class CommentHelperBuilder {
        private Issue issue;
        private Comment comment;

        public CommentHelperBuilder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public CommentHelperBuilder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        public CommentHelper build() {
            if (this.issue != null) {
                return new CommentHelper(ExecutingHttpRequest.get(), this.issue.getProjectObject(), (Option<Issue>)Option.option((Object)this.issue), (Option<Comment>)Option.option((Object)this.comment));
            }
            return new CommentHelper(ExecutingHttpRequest.get(), null, (Option<Issue>)Option.none(), (Option<Comment>)Option.none());
        }
    }
}

