/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.util;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.plugin.util.PluginsTracker;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Immutable
public class SimplePluginsTracker
implements PluginsTracker {
    private final Set<PluginsTracker.PluginInfo> pluginsInvolved;

    public SimplePluginsTracker(List<Plugin> trackedPlugins) {
        this.pluginsInvolved = (Set)trackedPlugins.stream().map(this::toInfo).collect(CollectorsUtil.toImmutableSet());
    }

    private PluginsTracker.PluginInfo toInfo(Plugin plugin) {
        return new PluginsTracker.PluginInfo(plugin.getKey(), plugin.getPluginInformation().getVersion());
    }

    @Override
    public boolean isPluginInvolved(Plugin plugin) {
        return this.pluginsInvolved.contains(this.toInfo((Plugin)Assertions.notNull((String)"plugin", (Object)plugin)));
    }

    @Override
    public boolean isPluginInvolved(ModuleDescriptor moduleDescriptor) {
        return this.pluginsInvolved.contains(this.toInfo(((ModuleDescriptor)Assertions.notNull((String)"moduleDescriptor", (Object)moduleDescriptor)).getPlugin()));
    }

    @Override
    public String getStateHashCode() {
        return Integer.toString(this.pluginsInvolved.hashCode(), 36);
    }

    public String toString() {
        return super.toString() + " " + this.pluginsInvolved.toString();
    }
}

