/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.permission.IssueLiteralSanitiser;
import com.atlassian.jira.jql.permission.LiteralSanitiser;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.plugin.jql.function.ClauseSanitisingJqlFunction;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LinkedIssuesFunction
extends AbstractJqlFunction
implements ClauseSanitisingJqlFunction {
    public static final String FUNCTION_LINKED_ISSUES = "linkedIssues";
    private final JqlIssueSupport jqlIssueSupport;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final PermissionManager permissionManager;

    public LinkedIssuesFunction(JqlIssueSupport jqlIssueSupport, IssueLinkTypeManager issueLinkTypeManager, IssueLinkManager issueLinkManager, PermissionManager permissionManager) {
        this.jqlIssueSupport = (JqlIssueSupport)Assertions.notNull((String)"jqlIssueSupport", (Object)jqlIssueSupport);
        this.issueLinkTypeManager = (IssueLinkTypeManager)Assertions.notNull((String)"issueLinkTypeManager", (Object)issueLinkTypeManager);
        this.issueLinkManager = (IssueLinkManager)Assertions.notNull((String)"issueLinkManager", (Object)issueLinkManager);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand operand, TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (!this.issueLinkManager.isLinkingEnabled()) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.issue.linking.disabled", this.getFunctionName()));
            return messageSet;
        }
        List args = operand.getArgs();
        if (args.isEmpty()) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.linked.issues.incorrect.usage", this.getFunctionName()));
            return messageSet;
        }
        String issueArg = (String)args.get(0);
        Collection<Issue> issues = this.getIssuesForArg(issueArg, searcher, false);
        if (issues == null) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.linked.issues.issue.not.found", this.getFunctionName(), issueArg));
            return messageSet;
        }
        if (args.size() > 1) {
            for (int i = 1; i < args.size(); ++i) {
                String linkDescArg = (String)args.get(i);
                Map<Direction, Collection<IssueLinkType>> linkTypeMapping = this.getIssueLinkTypesForArg(linkDescArg);
                if (linkTypeMapping != null) continue;
                messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.linked.issues.link.type.not.found", this.getFunctionName(), linkDescArg));
                return messageSet;
            }
        }
        return messageSet;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        LinkedList<QueryLiteral> literals = new LinkedList<QueryLiteral>();
        if (!this.issueLinkManager.isLinkingEnabled()) {
            return literals;
        }
        List args = operand.getArgs();
        if (args.isEmpty()) {
            return literals;
        }
        String issueArg = (String)args.get(0);
        Collection<Issue> rootIssues = this.getIssuesForArg(issueArg, queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden());
        if (rootIssues == null) {
            return literals;
        }
        Map<Direction, Collection<IssueLinkType>> linkTypeMapping = null;
        if (args.size() > 1 && (linkTypeMapping = this.getIssueLinkTypesForArgs(args.subList(1, args.size()))) == null) {
            return literals;
        }
        Collection<Issue> linkedIssues = this.getLinkedIssues(queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden(), rootIssues, linkTypeMapping);
        for (Issue issue : linkedIssues) {
            literals.add(new QueryLiteral((Operand)operand, issue.getId()));
        }
        return literals;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }

    public FunctionOperand sanitiseOperand(ApplicationUser searcher, FunctionOperand operand) {
        List args = operand.getArgs();
        if (args.isEmpty()) {
            return operand;
        }
        QueryLiteral literal = new QueryLiteral((Operand)operand, (String)args.get(0));
        LiteralSanitiser.Result result = this.createLiteralSanitiser(searcher).sanitiseLiterals(Collections.singletonList(literal));
        if (!result.isModified()) {
            return operand;
        }
        List sanitisedArgs = CollectionUtil.transform(result.getLiterals(), (Function)new Function<QueryLiteral, String>(){

            public String get(QueryLiteral input) {
                return input.asString();
            }
        });
        ArrayList newArgs = new ArrayList();
        newArgs.add(sanitisedArgs.get(0));
        if (args.size() > 1) {
            newArgs.addAll(args.subList(1, args.size()));
        }
        return new FunctionOperand(operand.getName(), newArgs);
    }

    LiteralSanitiser createLiteralSanitiser(ApplicationUser user) {
        return new IssueLiteralSanitiser(this.permissionManager, this.jqlIssueSupport, user);
    }

    Collection<Issue> getIssuesForArg(String issueArg, ApplicationUser searcher, boolean overrideSecurity) {
        Issue issueByKey;
        Issue issue = issueByKey = overrideSecurity ? this.jqlIssueSupport.getIssue(issueArg) : this.jqlIssueSupport.getIssue(issueArg, searcher);
        if (issueByKey != null) {
            return Collections.singleton(issueByKey);
        }
        Long issueId = this.getLong(issueArg);
        if (issueId != null) {
            Issue issueById;
            Issue issue2 = issueById = overrideSecurity ? this.jqlIssueSupport.getIssue(issueId.longValue()) : this.jqlIssueSupport.getIssue(issueId.longValue(), searcher);
            if (issueById != null) {
                return Collections.singleton(issueById);
            }
        }
        return null;
    }

    Map<Direction, Collection<IssueLinkType>> getIssueLinkTypesForArg(String linkDescArg) {
        Collection outwardLinkTypes;
        HashMap<Direction, Collection<IssueLinkType>> result = new HashMap<Direction, Collection<IssueLinkType>>();
        Collection inwardLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByInwardDescription(linkDescArg);
        if (!inwardLinkTypes.isEmpty()) {
            result.put(Direction.IN, inwardLinkTypes);
        }
        if (!(outwardLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByOutwardDescription(linkDescArg)).isEmpty()) {
            result.put(Direction.OUT, outwardLinkTypes);
        }
        return result.isEmpty() ? null : result;
    }

    Map<Direction, Collection<IssueLinkType>> getIssueLinkTypesForArgs(List<String> linkDescArgs) {
        LinkedHashSet<IssueLinkType> inLinkTypes = new LinkedHashSet<IssueLinkType>();
        LinkedHashSet<IssueLinkType> outLinkTypes = new LinkedHashSet<IssueLinkType>();
        for (String linkDescArg : linkDescArgs) {
            Map<Direction, Collection<IssueLinkType>> linkTypeMapping = this.getIssueLinkTypesForArg(linkDescArg);
            if (linkTypeMapping != null) {
                Collection<IssueLinkType> outs;
                Collection<IssueLinkType> ins = linkTypeMapping.get((Object)Direction.IN);
                if (ins != null) {
                    inLinkTypes.addAll(ins);
                }
                if ((outs = linkTypeMapping.get((Object)Direction.OUT)) == null) continue;
                outLinkTypes.addAll(outs);
                continue;
            }
            return null;
        }
        return MapBuilder.newBuilder().add((Object)Direction.IN, inLinkTypes).add((Object)Direction.OUT, outLinkTypes).toMap();
    }

    Collection<Issue> getLinkedIssues(ApplicationUser searcher, boolean overrideSecurity, Collection<Issue> rootIssues, Map<Direction, Collection<IssueLinkType>> linkTypeMappings) {
        LinkedHashSet<Issue> linkedIssues = new LinkedHashSet<Issue>();
        LinkedHashSet<LinkCollection> linkCollections = new LinkedHashSet<LinkCollection>();
        for (Issue issue : rootIssues) {
            LinkCollection collection = overrideSecurity ? this.issueLinkManager.getLinkCollectionOverrideSecurity(issue) : this.issueLinkManager.getLinkCollection(issue, searcher);
            linkCollections.add(collection);
        }
        for (LinkCollection linkCollection : linkCollections) {
            if (linkTypeMappings != null) {
                for (Direction direction : linkTypeMappings.keySet()) {
                    Collection<IssueLinkType> linkTypes = linkTypeMappings.get((Object)direction);
                    for (IssueLinkType linkType : linkTypes) {
                        List issues = null;
                        switch (direction) {
                            case IN: {
                                issues = linkCollection.getInwardIssues(linkType.getName());
                                break;
                            }
                            case OUT: {
                                issues = linkCollection.getOutwardIssues(linkType.getName());
                            }
                        }
                        if (issues == null) continue;
                        linkedIssues.addAll(issues);
                    }
                }
                continue;
            }
            linkedIssues.addAll(linkCollection.getAllIssues());
        }
        return linkedIssues;
    }

    private Long getLong(String s) {
        try {
            return new Long(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static enum Direction {
        IN("in"),
        OUT("out");

        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

