/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_ISSUE_HISTORY = "issueHistory";
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryFunction.class);
    private final UserIssueHistoryManager userHistoryManager;

    public IssueHistoryFunction(UserIssueHistoryManager userHistoryManager) {
        this.userHistoryManager = (UserIssueHistoryManager)Assertions.notNull((String)"userHistoryManager", (Object)userHistoryManager);
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand operand, TerminalClause terminalClause) {
        return this.validateNumberOfArgs(operand, 0);
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        LinkedList<QueryLiteral> literals = new LinkedList<QueryLiteral>();
        List history = queryCreationContext.isSecurityOverriden() ? this.userHistoryManager.getFullIssueHistoryWithoutPermissionChecks(queryCreationContext.getQueryUser()) : this.userHistoryManager.getFullIssueHistoryWithPermissionChecks(queryCreationContext.getQueryUser());
        for (UserHistoryItem userHistoryItem : history) {
            String value = userHistoryItem.getEntityId();
            try {
                literals.add(new QueryLiteral((Operand)operand, Long.valueOf(Long.parseLong(value))));
            }
            catch (NumberFormatException e) {
                log.warn(String.format("User history returned a non numeric issue ID '%s'.", value));
            }
        }
        return literals;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }
}

