/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel3Adaptor;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueTabPanelModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<IssueTabPanel3>
implements IssueTabPanelModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPanelModuleDescriptorImpl.class);
    String label;
    private String labelKey;
    boolean isDefault = false;
    private int order;
    private boolean isSortable = false;
    private boolean supportsAjaxLoad;

    public IssueTabPanelModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.label = element.element("label").getTextTrim();
        if (element.element("label").attribute("key") != null) {
            this.labelKey = element.element("label").attribute("key").getText();
        }
        this.isDefault = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "default");
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
        this.isSortable = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "sortable");
        this.supportsAjaxLoad = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "supports-ajax-load");
    }

    @Override
    public void enabled() {
        super.enabled();
    }

    private static boolean getBooleanElement(Element parentElement, String elementName) {
        Element element = parentElement.element(elementName);
        if (element == null) {
            return false;
        }
        String isDefaultText = element.getTextTrim();
        return isDefaultText != null && Boolean.valueOf(isDefaultText) != false;
    }

    private IssueTabPanel3 getTabPanel() {
        return (IssueTabPanel3)this.getModule();
    }

    public String getLabel() {
        if (this.labelKey != null) {
            return this.getI18nBean().getText(this.labelKey);
        }
        return this.label;
    }

    @Override
    protected IssueTabPanel3 createModule() {
        IssueTabPanel3 issueTabPanel;
        Object module = this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        if (module instanceof IssueTabPanel) {
            issueTabPanel = IssueTabPanel3Adaptor.createFrom((IssueTabPanel)module);
        } else if (module instanceof IssueTabPanel3) {
            issueTabPanel = (IssueTabPanel3)module;
        } else {
            throw new ClassCastException("Class " + module.getClass().getCanonicalName() + " is not a legal class for issue tab panel plugin point.");
        }
        issueTabPanel.init((IssueTabPanelModuleDescriptor)this);
        return issueTabPanel;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isSortable() {
        return this.isSortable;
    }

    public boolean isSupportsAjaxLoad() {
        return this.supportsAjaxLoad;
    }
}

