/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.data;

import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionScheme;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class PermissionSchemeImpl
implements PermissionScheme {
    private final Long id;
    private final String name;
    private final String description;
    private final List<PermissionGrant> permissions;

    public PermissionSchemeImpl(Long id, String name, @Nullable String description) {
        this(id, name, description, Collections.emptyList());
    }

    public PermissionSchemeImpl(Long id, String name, @Nullable String description, Iterable<PermissionGrant> permissions) {
        this.id = (Long)Preconditions.checkNotNull((Object)id);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        this.permissions = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(permissions)));
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PermissionGrant> getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionSchemeImpl that = (PermissionSchemeImpl)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.permissions, that.permissions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description, this.permissions});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("permissions", this.permissions).toString();
    }
}

