/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.permission.Permission;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@Deprecated
public class SchemePermissions {
    private ImmutableMap<Integer, Permission> projectPermissions = SchemePermissions.toMap(Permission.PROJECT_ADMIN, Permission.BROWSE, Permission.VIEW_VERSION_CONTROL, Permission.VIEW_WORKFLOW_READONLY);
    private ImmutableMap<Integer, Permission> issuePermissions = SchemePermissions.toMap(Permission.CREATE_ISSUE, Permission.EDIT_ISSUE, Permission.TRANSITION_ISSUE, Permission.SCHEDULE_ISSUE, Permission.MOVE_ISSUE, Permission.ASSIGN_ISSUE, Permission.ASSIGNABLE_USER, Permission.RESOLVE_ISSUE, Permission.CLOSE_ISSUE, Permission.MODIFY_REPORTER, Permission.DELETE_ISSUE, Permission.LINK_ISSUE, Permission.SET_ISSUE_SECURITY);
    private ImmutableMap<Integer, Permission> votersAndWatchersPermissions = SchemePermissions.toMap(Permission.VIEW_VOTERS_AND_WATCHERS, Permission.MANAGE_WATCHER_LIST);
    private ImmutableMap<Integer, Permission> commentsPermissions = SchemePermissions.toMap(Permission.COMMENT_ISSUE, Permission.COMMENT_EDIT_ALL, Permission.COMMENT_EDIT_OWN, Permission.COMMENT_DELETE_ALL, Permission.COMMENT_DELETE_OWN);
    private ImmutableMap<Integer, Permission> attachmentsPermissions = SchemePermissions.toMap(Permission.CREATE_ATTACHMENT, Permission.ATTACHMENT_DELETE_ALL, Permission.ATTACHMENT_DELETE_OWN);
    private ImmutableMap<Integer, Permission> timeTrackingPermissions = SchemePermissions.toMap(Permission.WORK_ISSUE, Permission.WORKLOG_EDIT_OWN, Permission.WORKLOG_EDIT_ALL, Permission.WORKLOG_DELETE_OWN, Permission.WORKLOG_DELETE_ALL);
    private ImmutableMap<Integer, Permission> permissions = ImmutableMap.builder().putAll(this.projectPermissions).putAll(this.issuePermissions).putAll(this.votersAndWatchersPermissions).putAll(this.commentsPermissions).putAll(this.attachmentsPermissions).putAll(this.timeTrackingPermissions).build();

    private static ImmutableMap<Integer, Permission> toMap(Permission ... permissions) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Permission permission : permissions) {
            map.put((Object)permission.getId(), (Object)permission);
        }
        return map.build();
    }

    public Map<Integer, Permission> getProjectPermissions() {
        return this.projectPermissions;
    }

    public Map<Integer, Permission> getIssuePermissions() {
        return this.issuePermissions;
    }

    public Map<Integer, Permission> getVotersAndWatchersPermissions() {
        return this.votersAndWatchersPermissions;
    }

    public Map<Integer, Permission> getCommentsPermissions() {
        return this.commentsPermissions;
    }

    public Map<Integer, Permission> getAttachmentsPermissions() {
        return this.attachmentsPermissions;
    }

    public Map<Integer, Permission> getTimeTrackingPermissions() {
        return this.timeTrackingPermissions;
    }

    public Map<Integer, Permission> getSchemePermissions() {
        return this.permissions;
    }

    public boolean schemePermissionExists(Integer id) {
        return this.getSchemePermissions().containsKey(id);
    }

    public String getPermissionName(Integer id) {
        return this.getSchemePermissions().get(id).getNameKey();
    }

    public String getPermissionDescription(int id) {
        if (this.getSchemePermissions().get(id) != null) {
            return this.getSchemePermissions().get(id).getDescription();
        }
        return "";
    }
}

