/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.license.LegacyMultiLicenseStore;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.license.MultiLicenseStoreImpl;
import com.atlassian.jira.license.RenaissanceMigrationStatus;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.inject.Inject;

@EventComponent
public class RenaissanceSwitchingMultiLicenseStore
implements MultiLicenseStore {
    private final MultiLicenseStore jira6xStore;
    private final MultiLicenseStore jira7xStore;
    private final RenaissanceMigrationStatus predicate;
    private volatile boolean migrationDone = false;

    @Inject
    public RenaissanceSwitchingMultiLicenseStore(LegacyMultiLicenseStore jira6xStore, MultiLicenseStoreImpl jira7xStore, RenaissanceMigrationStatus predicate) {
        this((MultiLicenseStore)jira6xStore, (MultiLicenseStore)jira7xStore, predicate);
    }

    @VisibleForTesting
    RenaissanceSwitchingMultiLicenseStore(MultiLicenseStore jira6xStore, MultiLicenseStore jira7xStore, RenaissanceMigrationStatus predicate) {
        this.jira6xStore = (MultiLicenseStore)Assertions.notNull((String)"jira6xStore", (Object)jira6xStore);
        this.jira7xStore = (MultiLicenseStore)Assertions.notNull((String)"jira7xStore", (Object)jira7xStore);
        this.predicate = (RenaissanceMigrationStatus)Assertions.notNull((String)"predicate", (Object)predicate);
    }

    @Override
    @Nonnull
    public Iterable<String> retrieve() {
        return this.delegate().retrieve();
    }

    @Override
    public void store(@Nonnull Iterable<String> licenses) {
        this.delegate().store(licenses);
    }

    @Override
    public String retrieveServerId() {
        return this.delegate().retrieveServerId();
    }

    @Override
    public void storeServerId(String serverId) {
        this.delegate().storeServerId(serverId);
    }

    @Override
    public void resetOldBuildConfirmation() {
        this.delegate().resetOldBuildConfirmation();
    }

    @Override
    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.delegate().confirmProceedUnderEvaluationTerms(userName);
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    @Override
    public void clearCache() {
        this.delegate().clearCache();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent dataImport) {
        this.migrationDone = false;
    }

    @Nonnull
    private MultiLicenseStore delegate() {
        if (this.migrationDone) {
            return this.jira7xStore;
        }
        this.migrationDone = this.predicate.hasMigrationRun();
        if (!this.migrationDone) {
            return this.jira6xStore;
        }
        return this.jira7xStore;
    }
}

