/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.issue.comparator.LocaleSensitiveNamedComparator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ProjectCategoryClauseValuesGenerator
implements ClauseValuesGenerator {
    private final ProjectManager projectManager;

    public ProjectCategoryClauseValuesGenerator(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList projectCategories = new ArrayList(this.projectManager.getAllProjectCategories());
        Collections.sort(projectCategories, new LocaleSensitiveNamedComparator(this.getLocale(searcher)));
        ArrayList results = Lists.newArrayListWithCapacity((int)projectCategories.size());
        for (ProjectCategory projectCategory : projectCategories) {
            if (results.size() == maxNumResults) break;
            String categoryName = projectCategory.getName();
            String lowerCaseCategoryName = categoryName.toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseCategoryName.startsWith(valuePrefix.toLowerCase())) continue;
            results.add(new ClauseValuesGenerator.Result(categoryName));
        }
        return new ClauseValuesGenerator.Results((List)results);
    }

    Locale getLocale(ApplicationUser searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

