/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResolverImpl
implements UserResolver {
    private static final Logger log = LoggerFactory.getLogger(UserResolverImpl.class);
    private final UserKeyService userKeyService;
    private final UserManager userManager;
    private final UserSearchService userSearchService;

    public UserResolverImpl(UserKeyService userKeyService, UserManager userManager, UserSearchService userSearchService) {
        this.userKeyService = userKeyService;
        this.userManager = userManager;
        this.userSearchService = userSearchService;
    }

    public List<String> getIdsFromName(String name) {
        Assertions.notNull((String)"name", (Object)name);
        String userkey = this.userKeyService.getKeyForUsername(name);
        if (userkey != null) {
            return Collections.singletonList(userkey);
        }
        return this.getUsersFromFullNameOrEmail(name);
    }

    public boolean nameExists(String name) {
        Assertions.notNull((String)"name", (Object)name);
        if (this.userKeyService.getKeyForUsername(name) != null) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Username '" + name + "' not found - searching as email or full name.");
        }
        return this.hasAnyFullNameOrEmailMatches(name);
    }

    public boolean idExists(Long id) {
        return this.nameExists(((Long)Assertions.notNull((String)"id", (Object)id)).toString());
    }

    private List<String> pickEmailOrFullNameMatches(String name, List<String> fullNameMatches, List<String> emailMatches) {
        if (emailMatches.isEmpty()) {
            return fullNameMatches;
        }
        if (fullNameMatches.isEmpty() || this.isEmail(name)) {
            return emailMatches;
        }
        return fullNameMatches;
    }

    private List<String> getUsersFromFullNameOrEmail(String name) {
        Iterable fullNameMatches = this.userSearchService.findUserKeysByFullName(name);
        Iterable emailMatches = this.userSearchService.findUserKeysByEmail(name);
        return this.pickEmailOrFullNameMatches(name, (List<String>)ImmutableList.copyOf((Iterable)fullNameMatches), (List<String>)ImmutableList.copyOf((Iterable)emailMatches));
    }

    private boolean hasAnyFullNameOrEmailMatches(String name) {
        return this.userSearchService.findUserKeysByFullName(name).iterator().hasNext() || this.userSearchService.findUserKeysByEmail(name).iterator().hasNext();
    }

    private boolean isEmail(String name) {
        return TextUtils.verifyEmail((String)name);
    }

    public ApplicationUser get(Long id) {
        return this.getApplicationUser(id);
    }

    public ApplicationUser getApplicationUser(Long id) {
        return this.getApplicationUser(id.toString());
    }

    @Nonnull
    public Collection<ApplicationUser> getAll() {
        return this.userManager.getUsers();
    }

    ApplicationUser getApplicationUser(String name) {
        return this.userManager.getUserByName(name);
    }
}

