/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand.registry;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.registry.PredicateRegistry;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.UserClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.operator.Operator;
import java.util.Collection;

public class DefaultPredicateRegistry
implements PredicateRegistry {
    private final UserSearchService userSearchService;
    private final SearchHandlerManager searchHandlerManager;
    private final JiraAuthenticationContext authenticationContext;

    public DefaultPredicateRegistry(UserSearchService userSearchService, SearchHandlerManager searchHandlerManager, JiraAuthenticationContext authenticationContext) {
        this.userSearchService = userSearchService;
        this.searchHandlerManager = searchHandlerManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public ClauseValuesGenerator getClauseValuesGenerator(String predicateName, String fieldName) {
        if (Operator.BY.name().equalsIgnoreCase(predicateName)) {
            return new UserClauseValuesGenerator(this.userSearchService);
        }
        if (Operator.FROM.name().equalsIgnoreCase(predicateName) || Operator.TO.name().equalsIgnoreCase(predicateName)) {
            return this.getClauseValuesGeneratorForField(fieldName);
        }
        return null;
    }

    private ClauseValuesGenerator getClauseValuesGeneratorForField(String fieldName) {
        ClauseHandler clauseHandler;
        ApplicationUser searcher = this.authenticationContext.getUser();
        Collection clauseHandlers = this.searchHandlerManager.getClauseHandler(searcher, fieldName);
        if (clauseHandlers != null && clauseHandlers.size() == 1 && (clauseHandler = (ClauseHandler)clauseHandlers.iterator().next()) instanceof ValueGeneratingClauseHandler) {
            return ((ValueGeneratingClauseHandler)clauseHandler).getClauseValuesGenerator();
        }
        return null;
    }
}

