/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.context.AllProjectsContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.IssueTypeResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.HashSet;
import java.util.List;

public class IssueTypeClauseContextFactory
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final IssueConstantInfoResolver<IssueType> resolver;
    private final ConstantsManager constantsManager;

    public IssueTypeClauseContextFactory(IssueTypeResolver issueTypeResolver, JqlOperandResolver jqlOperandResolver, ConstantsManager constantsManager) {
        this.constantsManager = (ConstantsManager)Assertions.notNull((String)"constantsManager", (Object)constantsManager);
        this.resolver = new IssueConstantInfoResolver((NameResolver)Assertions.notNull((String)"issueTypeResolver", (Object)issueTypeResolver));
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
    }

    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List values = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        HashSet<String> issueTypeIds = new HashSet<String>();
        if (values != null) {
            for (QueryLiteral value : values) {
                if (value.isEmpty()) continue;
                issueTypeIds.addAll(this.getIds(value));
            }
        }
        if (!issueTypeIds.isEmpty() && this.isNegationOperator(operator)) {
            HashSet allIssueTypes = new HashSet(this.constantsManager.getAllIssueTypeIds());
            allIssueTypes.removeAll(issueTypeIds);
            issueTypeIds = allIssueTypes;
        }
        if (issueTypeIds.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        HashSet<ProjectIssueTypeContextImpl> contexts = new HashSet<ProjectIssueTypeContextImpl>();
        for (String issueTypeId : issueTypeIds) {
            contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)AllProjectsContext.INSTANCE, (IssueTypeContext)new IssueTypeContextImpl(issueTypeId)));
        }
        return new ClauseContextImpl(contexts);
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    List<String> getIds(QueryLiteral value) {
        if (value.getStringValue() != null) {
            return this.resolver.getIndexedValues(value.getStringValue());
        }
        if (value.getLongValue() != null) {
            return this.resolver.getIndexedValues(value.getLongValue());
        }
        throw new IllegalStateException("Invalid query literal.");
    }
}

