/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.transformer.AbstractProjectConstantsSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.VersionSearchInput;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class VersionSearchInputTransformer
extends AbstractProjectConstantsSearchInputTransformer<Version, VersionSearchInput> {
    public VersionSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, VersionResolver versionResolver) {
        super(clauseNames, urlParameterName, operandResolver, fieldFlagOperandRegistry, versionResolver);
    }

    @Override
    @Nonnull
    VersionSearchInput parseInputParam(String[] parts) {
        if (parts[0].equals("-1")) {
            return VersionSearchInput.noVersions();
        }
        if (parts[0].equals("-3")) {
            return VersionSearchInput.allReleased();
        }
        if (parts[0].equals("-2")) {
            return VersionSearchInput.allUnreleased();
        }
        if (parts[0].equals("id")) {
            return VersionSearchInput.version(parts[1]);
        }
        return VersionSearchInput.version(parts[0]);
    }

    @Override
    @Nonnull
    VersionSearchInput noValueInput() {
        return VersionSearchInput.noVersions();
    }

    @Override
    @Nonnull
    VersionSearchInput inputValue(String value) {
        return VersionSearchInput.version(value);
    }

    @Override
    void parseFunctionOperand(FunctionOperand operand, Set<VersionSearchInput> values) {
        if ("releasedVersions".equals(operand.getName())) {
            values.add(VersionSearchInput.allReleased());
        } else if ("unreleasedVersions".equals(operand.getName())) {
            values.add(VersionSearchInput.allUnreleased());
        }
    }

    @Override
    @Nonnull
    Operand parseInputValue(VersionSearchInput value) {
        if (value.isAllUnreleased()) {
            return new FunctionOperand("unreleasedVersions");
        }
        if (value.isAllReleased()) {
            return new FunctionOperand("releasedVersions");
        }
        if (value.isNoVersion()) {
            return EmptyOperand.EMPTY;
        }
        return new SingleValueOperand(value.getValue());
    }

    @Override
    boolean checkClauseValuesForBasic(QueryLiteral queryLiteral) {
        List ids;
        if (queryLiteral.isEmpty()) {
            return false;
        }
        if (queryLiteral.getStringValue() != null) {
            ids = this.nameResolver.getIdsFromName(queryLiteral.asString());
        } else if (queryLiteral.getLongValue() != null) {
            if (this.nameResolver.idExists(queryLiteral.getLongValue())) {
                return false;
            }
            ids = this.nameResolver.getIdsFromName(queryLiteral.asString());
        } else {
            return false;
        }
        for (String id : ids) {
            Version version;
            Long lid = VersionSearchInputTransformer.parseLong(id);
            if (lid == null || (version = (Version)this.nameResolver.get(lid)) == null || version.isArchived()) continue;
            return true;
        }
        return false;
    }

    private static Long parseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

