/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.transformer.AbstractProjectConstantsSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.ComponentSearchInput;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.ComponentResolver;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.Set;
import javax.annotation.Nonnull;

public class ComponentSearchInputTransformer
extends AbstractProjectConstantsSearchInputTransformer<ProjectComponent, ComponentSearchInput> {
    public ComponentSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, ComponentResolver componentResolver) {
        super(clauseNames, urlParameterName, operandResolver, fieldFlagOperandRegistry, componentResolver);
    }

    @Override
    @Nonnull
    ComponentSearchInput parseInputParam(String[] parts) {
        if (parts[0].equals("-1")) {
            return ComponentSearchInput.noComponents();
        }
        if (parts[0].equals("id")) {
            return ComponentSearchInput.component(parts[1]);
        }
        return ComponentSearchInput.component(parts[0]);
    }

    @Override
    @Nonnull
    ComponentSearchInput noValueInput() {
        return ComponentSearchInput.noComponents();
    }

    @Override
    @Nonnull
    ComponentSearchInput inputValue(String value) {
        return ComponentSearchInput.component(value);
    }

    @Override
    void parseFunctionOperand(FunctionOperand operand, Set<ComponentSearchInput> values) {
    }

    @Override
    @Nonnull
    Operand parseInputValue(ComponentSearchInput value) {
        if (value.isNoComponent()) {
            return EmptyOperand.EMPTY;
        }
        return new SingleValueOperand(value.getValue());
    }

    @Override
    boolean checkClauseValuesForBasic(QueryLiteral literal) {
        if (literal.getStringValue() != null) {
            return this.nameResolver.nameExists(literal.asString());
        }
        if (literal.getLongValue() != null) {
            return this.nameResolver.nameExists(literal.asString()) && !this.nameResolver.idExists(literal.getLongValue());
        }
        return false;
    }
}

