/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.google.common.base.Joiner;
import java.util.Map;
import webwork.action.Action;

public class LabelsSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    public static final String SEPARATOR_CHAR = ", ";
    private final SimpleFieldSearchConstantsWithEmpty constants;
    private FieldVisibilityManager fieldVisibilityManager;

    public LabelsSearchRenderer(SimpleFieldSearchConstantsWithEmpty constants, VelocityRequestContextFactory velocityRequestContextFactory, FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String nameKey) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, constants.getSearcherId(), nameKey);
        this.constants = constants;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("labels", this.getLabels(fieldValuesHolder));
        return this.renderEditTemplate("labels-searcher-edit.vm", velocityParams);
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("labelString", this.getLabelString(fieldValuesHolder));
        return this.renderViewTemplate("labels-searcher-view.vm", velocityParams);
    }

    private String getLabelString(FieldValuesHolder fieldValuesHolder) {
        return Joiner.on((String)SEPARATOR_CHAR).join(this.getLabels(fieldValuesHolder));
    }

    private Iterable<?> getLabels(FieldValuesHolder fieldValuesHolder) {
        return (Iterable)fieldValuesHolder.get((Object)"labels");
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.constants.getFieldId(), searchContext, user);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }
}

