/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import com.atlassian.jira.ofbiz.FieldMap;
import java.util.Map;

public class IssueTypeQuickSearchHandler
extends SingleWordQuickSearchHandler {
    public final ConstantsManager constantsManager;

    public IssueTypeQuickSearchHandler(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public IssueConstant getTypeByName(String name) {
        return IssueTypeQuickSearchHandler.getIssueConstantByName(this.constantsManager.getRegularIssueTypeObjects(), name);
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        IssueConstant typeByName = this.getTypeByName(word);
        if (typeByName == null && (word.endsWith("S") || word.endsWith("s"))) {
            typeByName = this.getTypeByName(word.substring(0, word.length() - 1));
        }
        return typeByName != null ? FieldMap.build((String)"type", (Object)typeByName.getId()) : null;
    }
}

