/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterCache;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.util.profiling.UtilTimerStack;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsFilterGeneratorImpl
implements PermissionsFilterGenerator {
    private static final Logger log = LoggerFactory.getLogger(PermissionsFilterGeneratorImpl.class);
    private final PermissionQueryFactory permissionQueryFactory;

    public PermissionsFilterGeneratorImpl(PermissionQueryFactory permissionQueryFactory) {
        this.permissionQueryFactory = permissionQueryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getQuery(ApplicationUser searcher) {
        try {
            UtilTimerStack.push((String)"Permission Query");
            Query query = this.getCache().getQuery(searcher);
            if (query == null) {
                query = this.permissionQueryFactory.getQuery(searcher, ProjectPermissions.BROWSE_PROJECTS);
                this.getCache().storeQuery(query, searcher);
            }
            Query query2 = query;
            return query2;
        }
        finally {
            UtilTimerStack.pop((String)"Permission Query");
        }
    }

    PermissionsFilterCache getCache() {
        PermissionsFilterCache cache = (PermissionsFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new PermissionsFilterCache");
            }
            cache = new PermissionsFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.filter.cache", cache);
        }
        return cache;
    }
}

