/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.lucene.search.Query;

public class PermissionsFilterCache {
    private final Map cache = new LRUMap(50);

    public boolean hasQueryFor(ApplicationUser user) {
        return this.cache.containsKey(new CacheKey(user));
    }

    public Query getQuery(ApplicationUser user) {
        return (Query)this.cache.get(new CacheKey(user));
    }

    public void storeQuery(Query query, ApplicationUser user) {
        this.cache.put(new CacheKey(user), query);
    }

    public void flush() {
        this.cache.clear();
    }

    private static class CacheKey {
        String username;

        public CacheKey(ApplicationUser searcher) {
            if (searcher != null) {
                this.username = searcher.getName();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
        }

        public int hashCode() {
            return this.username != null ? this.username.hashCode() : 0;
        }
    }
}

