/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterCache;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionQueryFactory
implements PermissionQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionQueryFactory.class);
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionTypeManager permissionTypeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SecurityTypeManager issueSecurityTypeManager;

    public DefaultPermissionQueryFactory(IssueSecurityLevelManager issueSecurityLevelManager, PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, PermissionTypeManager permissionTypeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager issueSecurityTypeManager) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionTypeManager = permissionTypeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityTypeManager = issueSecurityTypeManager;
    }

    @Override
    public Query getQuery(ApplicationUser searcher, ProjectPermissionKey permissionKey) {
        try {
            BooleanQuery query = new BooleanQuery();
            Collection projects = this.permissionManager.getProjects(permissionKey, searcher);
            LinkedHashSet<Query> projectQueries = new LinkedHashSet<Query>();
            for (Object project : projects) {
                this.collectProjectTerms((Project)project, searcher, projectQueries, permissionKey);
            }
            BooleanQuery permissionQuery = new BooleanQuery();
            for (Query query2 : projectQueries) {
                permissionQuery.add(query2, BooleanClause.Occur.SHOULD);
            }
            if (!permissionQuery.clauses().isEmpty()) {
                query.add((Query)permissionQuery, BooleanClause.Occur.MUST);
                LinkedHashSet<Query> issueLevelSecurityQueries = new LinkedHashSet<Query>();
                issueLevelSecurityQueries.add((Query)new TermQuery(new Term(SystemSearchConstants.forSecurityLevel().getIndexField(), "-1")));
                try {
                    for (Project project : projects) {
                        this.collectSecurityLevelTerms(project, searcher, issueLevelSecurityQueries);
                    }
                }
                catch (GenericEntityException genericEntityException) {
                    log.error("Error occurred retrieving security levels for this user");
                }
                BooleanQuery booleanQuery = new BooleanQuery();
                for (Query issueLevelSecurityQuery : issueLevelSecurityQueries) {
                    booleanQuery.add(issueLevelSecurityQuery, BooleanClause.Occur.SHOULD);
                }
                query.add((Query)booleanQuery, BooleanClause.Occur.MUST);
            }
            return query;
        }
        catch (GenericEntityException e) {
            log.error("Error constructing query: " + (Object)((Object)e), (Throwable)e);
            return null;
        }
    }

    PermissionsFilterCache getCache() {
        PermissionsFilterCache cache = (PermissionsFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new PermissionsFilterCache");
            }
            cache = new PermissionsFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.filter.cache", cache);
        }
        return cache;
    }

    void collectProjectTerms(Project project, ApplicationUser searcherUser, Set<Query> queries, ProjectPermissionKey permissionId) throws GenericEntityException {
        Long schemeId = this.permissionSchemeManager.getSchemeIdFor(project);
        Collection entities = this.permissionSchemeManager.getPermissionSchemeEntries(schemeId.longValue(), permissionId);
        for (PermissionSchemeEntry schemeEntry : entities) {
            SecurityType securityType = this.permissionTypeManager.getSecurityType(schemeEntry.getType());
            if (securityType != null) {
                try {
                    Query tempQuery;
                    if (!this.userHasPermissionForProjectAndSecurityType(searcherUser, project, schemeEntry.getParameter(), securityType) || (tempQuery = securityType.getQuery(searcherUser, project, schemeEntry.getParameter())) == null) continue;
                    queries.add(tempQuery);
                }
                catch (Exception e) {
                    log.debug("Could not add query for security type:" + securityType.getDisplayName(), (Throwable)e);
                }
                continue;
            }
            log.debug("Could not find security type:" + schemeEntry.getType());
        }
    }

    void collectSecurityLevelTerms(Project project, ApplicationUser searcherUser, Set<Query> queries) throws GenericEntityException {
        List usersSecurityLevels = this.issueSecurityLevelManager.getUsersSecurityLevels(project, searcherUser);
        for (IssueSecurityLevel securityLevel : usersSecurityLevels) {
            List securities = this.issueSecuritySchemeManager.getPermissionsBySecurityLevel(securityLevel.getId());
            for (IssueSecurityLevelPermission securityLevelPermission : securities) {
                Query tempQuery;
                SecurityType securityType = this.issueSecurityTypeManager.getSecurityType(securityLevelPermission.getType());
                if (securityType == null || !this.userHasPermissionForProjectAndSecurityType(searcherUser, project, securityLevelPermission.getParameter(), securityType) || (tempQuery = securityType.getQuery(searcherUser, project, securityLevel, securityLevelPermission.getParameter())) == null) continue;
                queries.add(tempQuery);
            }
        }
    }

    boolean userHasPermissionForProjectAndSecurityType(ApplicationUser searcher, Project project, String parameter, SecurityType securityType) {
        boolean hasPermission = searcher == null ? securityType.hasPermission(project, parameter) : securityType.hasPermission(project, parameter, searcher, false);
        return hasPermission;
    }
}

