/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueConstants;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultLabelUtil
implements LabelUtil {
    private final SearchService searchService;
    private final CustomFieldManager customFieldManager;

    public DefaultLabelUtil(SearchService searchService, CustomFieldManager customFieldManager) {
        this.searchService = searchService;
        this.customFieldManager = customFieldManager;
    }

    public String getLabelJql(ApplicationUser user, String label) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        jqlClauseBuilder.labels(new String[]{label});
        return this.searchService.getQueryString(user, jqlQueryBuilder.buildQuery());
    }

    public String getLabelJql(ApplicationUser user, Long customFieldId, String label) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        CustomField labelField = this.customFieldManager.getCustomFieldObject(customFieldId);
        HashSet<Long> projectIds = new HashSet<Long>();
        List associatedProjects = labelField.getAssociatedProjectObjects();
        if (null != associatedProjects) {
            for (Project project : associatedProjects) {
                if (null == project) continue;
                projectIds.add(project.getId());
            }
        }
        return this.getLabelJql(user, labelField, projectIds, this.getAssociatedIssueTypeIds(labelField), label);
    }

    public String getLabelJqlForProject(ApplicationUser user, Long projectId, String label) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        jqlClauseBuilder.project(new Long[]{projectId}).and();
        if (label == null) {
            jqlClauseBuilder.labelsIsEmpty();
        } else {
            jqlClauseBuilder.labels(new String[]{label});
        }
        return this.searchService.getQueryString(user, jqlQueryBuilder.buildQuery());
    }

    public String getLabelJqlForProject(ApplicationUser user, Long projectId, Long customFieldId, String label) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        CustomField labelField = this.customFieldManager.getCustomFieldObject(customFieldId);
        return this.getLabelJql(user, labelField, CollectionBuilder.newBuilder((Object[])new Long[]{projectId}).asSet(), this.getAssociatedIssueTypeIds(labelField), label);
    }

    private String getLabelJql(ApplicationUser user, CustomField labelField, Set<Long> associatedProjectIds, Set<String> associatedIssueTypeIds, String label) {
        boolean hasAssociatedIssueTypeIds;
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        boolean hasAssociatedProjectIds = null != associatedProjectIds && !associatedProjectIds.isEmpty();
        boolean bl = hasAssociatedIssueTypeIds = null != associatedIssueTypeIds && !associatedIssueTypeIds.isEmpty();
        if (hasAssociatedProjectIds || hasAssociatedIssueTypeIds) {
            jqlClauseBuilder = jqlClauseBuilder.sub().defaultAnd();
            if (hasAssociatedProjectIds) {
                jqlClauseBuilder = jqlClauseBuilder.project(associatedProjectIds.toArray(new Long[associatedProjectIds.size()]));
            }
            if (hasAssociatedIssueTypeIds) {
                jqlClauseBuilder = jqlClauseBuilder.issueType(associatedIssueTypeIds.toArray(new String[associatedIssueTypeIds.size()]));
            }
            jqlClauseBuilder.endsub().and().customField(labelField.getIdAsLong()).eq().string(label);
        } else {
            jqlClauseBuilder.customField(labelField.getIdAsLong()).eq().string(label);
        }
        return this.searchService.getQueryString(user, jqlQueryBuilder.buildQuery());
    }

    private Set<String> getAssociatedIssueTypeIds(CustomField labelField) {
        return Sets.newTreeSet((Iterable)IssueConstants.toStringIdsWithoutNulls((Collection)labelField.getAssociatedIssueTypes()));
    }
}

