/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AbstractProgressBarSystemField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressIndexer
implements FieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(ProgressIndexer.class);
    private static final String PROGRESS_UNKNOWN = "-1";
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ApplicationProperties applicationProperties;

    public ProgressIndexer(FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.applicationProperties = applicationProperties;
    }

    public String getId() {
        return "progress";
    }

    public String getDocumentFieldId() {
        return "progress";
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", issue);
    }

    public void addIndex(Document doc, Issue issue) {
        try {
            Long percentage = AbstractProgressBarSystemField.calculateProgressPercentage(issue.getTimeSpent(), issue.getEstimate());
            if (this.isFieldVisibleAndInScope(issue)) {
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), percentage == null ? PROGRESS_UNKNOWN : percentage.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            } else {
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), percentage == null ? PROGRESS_UNKNOWN : percentage.toString(), Field.Store.YES, Field.Index.NO));
            }
        }
        catch (IllegalArgumentException mustBeNegative) {
            log.warn("Issue: '" + issue.getKey() + "' has an uncalculable percentage", (Throwable)mustBeNegative);
        }
    }
}

