/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueSearcherFactory;
import com.atlassian.jira.issue.index.SearcherCache;
import javax.annotation.Nonnull;
import org.apache.lucene.search.IndexSearcher;

public class DefaultIssueSearcherFactory
implements IssueSearcherFactory {
    private final IssueIndexer issueIndexer;
    private final IndexingConfiguration indexingConfiguration;

    public DefaultIssueSearcherFactory(IssueIndexer issueIndexer, IndexingConfiguration indexingConfiguration) {
        this.issueIndexer = issueIndexer;
        this.indexingConfiguration = indexingConfiguration;
    }

    @Override
    @Nonnull
    public IndexSearcher getEntitySearcher(IndexDirectoryFactory.Name index) {
        return SearcherCache.getThreadLocalCache().retrieveEntitySearcher(this.issueIndexer, this.indexingConfiguration, index);
    }
}

