/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class FieldScreenTabImpl
extends AbstractGVBean
implements FieldScreenTab {
    private final FieldScreenManager fieldScreenManager;
    private List<FieldScreenLayoutItem> layoutItems;
    private Map<String, FieldScreenLayoutItem> layoutItemsMap;
    private Long id;
    private String name;
    private int position;
    private FieldScreen fieldScreen;

    public FieldScreenTabImpl(FieldScreenManager fieldScreenManager) {
        this(fieldScreenManager, null);
    }

    public FieldScreenTabImpl(FieldScreenManager fieldScreenManager, GenericValue genericValue) {
        this.fieldScreenManager = fieldScreenManager;
        this.setGenericValue(genericValue);
        this.layoutItems = null;
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            if (this.getGenericValue().getLong("sequence") != null) {
                this.position = this.getGenericValue().getLong("sequence").intValue();
            }
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        this.updateGV("sequence", position);
    }

    public void store() {
        if (this.isModified()) {
            if (this.id == null) {
                this.fieldScreenManager.createFieldScreenTab((FieldScreenTab)this);
            } else {
                this.fieldScreenManager.updateFieldScreenTab((FieldScreenTab)this);
                this.setModified(false);
            }
        }
        if (this.layoutItems != null) {
            for (FieldScreenLayoutItem fieldScreenLayoutItem : this.getInternalLayoutItems()) {
                fieldScreenLayoutItem.store();
            }
        }
    }

    public void remove() {
        this.fieldScreenManager.removeFieldScreenLayoutItems((FieldScreenTab)this);
        this.fieldScreenManager.removeFieldScreenTab(this.getId());
    }

    public FieldScreen getFieldScreen() {
        return this.fieldScreen;
    }

    public void rename(String newName) {
        this.setName(newName);
        this.store();
    }

    public void setFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreen = fieldScreen;
        if (fieldScreen == null) {
            this.updateGV("fieldscreen", null);
        } else {
            this.updateGV("fieldscreen", fieldScreen.getId());
        }
    }

    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems() {
        return Collections.unmodifiableList(this.getInternalLayoutItems());
    }

    private List<FieldScreenLayoutItem> getInternalLayoutItems() {
        if (this.layoutItems == null) {
            this.initInternalItems();
        }
        return this.layoutItems;
    }

    private Map<String, FieldScreenLayoutItem> getInternalLayoutItemsMap() {
        if (this.layoutItemsMap == null) {
            this.initInternalItems();
        }
        return this.layoutItemsMap;
    }

    private void initInternalItems() {
        this.layoutItems = this.fieldScreenManager.getFieldScreenLayoutItems((FieldScreenTab)this);
        this.layoutItemsMap = new HashMap<String, FieldScreenLayoutItem>();
        for (FieldScreenLayoutItem fieldScreenLayoutItem : this.layoutItems) {
            this.layoutItemsMap.put(fieldScreenLayoutItem.getFieldId(), fieldScreenLayoutItem);
        }
    }

    public FieldScreenLayoutItem getFieldScreenLayoutItem(int poistion) {
        return this.getInternalLayoutItems().get(poistion);
    }

    public void addFieldScreenLayoutItem(String orderableFieldId) {
        this.addFieldScreenLayoutItem(orderableFieldId, this.getInternalLayoutItems().size());
    }

    public void addFieldScreenLayoutItem(String orderableFieldId, int position) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.fieldScreenManager.buildNewFieldScreenLayoutItem(orderableFieldId);
        fieldScreenLayoutItem.setFieldScreenTab((FieldScreenTab)this);
        this.getInternalLayoutItems().add(position, fieldScreenLayoutItem);
        this.getInternalLayoutItemsMap().put(fieldScreenLayoutItem.getFieldId(), fieldScreenLayoutItem);
        this.resequence(position);
        this.store();
    }

    public void moveFieldScreenLayoutItemFirst(int fieldPosition) {
        CollectionReorderer.moveToStart(this.getInternalLayoutItems(), this.getInternalLayoutItems().get(fieldPosition));
        this.resequence();
        this.store();
    }

    public void moveFieldScreenLayoutItemUp(int fieldPosition) {
        CollectionReorderer.increasePosition(this.getInternalLayoutItems(), this.getInternalLayoutItems().get(fieldPosition));
        this.resequence();
        this.store();
    }

    public void moveFieldScreenLayoutItemDown(int fieldPosition) {
        CollectionReorderer.decreasePosition(this.getInternalLayoutItems(), this.getInternalLayoutItems().get(fieldPosition));
        this.resequence();
        this.store();
    }

    public void moveFieldScreenLayoutItemLast(int fieldPosition) {
        CollectionReorderer.moveToEnd(this.getInternalLayoutItems(), this.getInternalLayoutItems().get(fieldPosition));
        this.resequence();
        this.store();
    }

    public FieldScreenLayoutItem removeFieldScreenLayoutItem(int fieldPosition) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.getInternalLayoutItems().remove(fieldPosition);
        this.getInternalLayoutItemsMap().remove(fieldScreenLayoutItem.getFieldId());
        fieldScreenLayoutItem.remove();
        this.resequence();
        this.store();
        return fieldScreenLayoutItem;
    }

    public void moveFieldScreenLayoutItemToPosition(Map<Integer, FieldScreenLayoutItem> positionsToFields) {
        if (positionsToFields.isEmpty()) {
            return;
        }
        CollectionReorderer.moveToPosition(this.getInternalLayoutItems(), positionsToFields);
        this.resequence();
        this.store();
    }

    public FieldScreenLayoutItem getFieldScreenLayoutItem(String fieldId) {
        return this.getInternalLayoutItemsMap().get(fieldId);
    }

    public boolean isContainsField(String fieldId) {
        return this.getInternalLayoutItemsMap().containsKey(fieldId);
    }

    private void resequence() {
        this.resequence(0);
    }

    private void resequence(int startIndex) {
        for (int i = startIndex; i < this.getInternalLayoutItems().size(); ++i) {
            FieldScreenLayoutItem fieldScreenLayoutItem = this.getInternalLayoutItems().get(i);
            fieldScreenLayoutItem.setPosition(i);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenTab)) {
            return false;
        }
        FieldScreenTab fieldScreenTab = (FieldScreenTab)o;
        if (this.position != fieldScreenTab.getPosition()) {
            return false;
        }
        if (this.id != null ? !this.id.equals(fieldScreenTab.getId()) : fieldScreenTab.getId() != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(fieldScreenTab.getName()) : fieldScreenTab.getName() != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + this.position;
        return result;
    }
}

