/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FieldScreenRenderTabImpl
implements FieldScreenRenderTab {
    private final String name;
    private final List<FieldScreenRenderLayoutItem> fieldScreenRenderLayoutItems;
    private final int position;

    public FieldScreenRenderTabImpl(String name, int position, List<FieldScreenRenderLayoutItem> fieldScreenRenderLayoutItems) {
        this.name = name;
        this.position = position;
        this.fieldScreenRenderLayoutItems = Collections.unmodifiableList(fieldScreenRenderLayoutItems);
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public List<FieldScreenRenderLayoutItem> getFieldScreenRenderLayoutItems() {
        return this.fieldScreenRenderLayoutItems;
    }

    public List<FieldScreenRenderLayoutItem> getFieldScreenRenderLayoutItemsForProcessing() {
        LinkedList<FieldScreenRenderLayoutItem> items = new LinkedList<FieldScreenRenderLayoutItem>(this.fieldScreenRenderLayoutItems);
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = (FieldScreenRenderLayoutItem)iterator.next();
            if (!"assignee".equals(fieldScreenRenderLayoutItem.getOrderableField().getId())) continue;
            iterator.remove();
            items.add(fieldScreenRenderLayoutItem);
            break;
        }
        return Collections.unmodifiableList(items);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenRenderTabImpl)) {
            return false;
        }
        FieldScreenRenderTabImpl fieldScreenRenderTab = (FieldScreenRenderTabImpl)o;
        if (this.position != fieldScreenRenderTab.position) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(fieldScreenRenderTab.name) : fieldScreenRenderTab.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + this.position;
        return result;
    }

    public int compareTo(FieldScreenRenderTab o) {
        if (o == null) {
            return 1;
        }
        if (o.getPosition() > this.position) {
            return -1;
        }
        if (o.getPosition() < this.position) {
            return 1;
        }
        return 0;
    }
}

