/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class EditableDefaultFieldLayoutImpl
extends FieldLayoutImpl
implements EditableDefaultFieldLayout {
    public EditableDefaultFieldLayoutImpl(GenericValue genericValue, List<FieldLayoutItem> fieldLayoutItems) {
        super(genericValue, new ArrayList<FieldLayoutItem>(fieldLayoutItems));
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            super.init();
        } else {
            this.setId(null);
            this.setName("Default Field Configuration");
            this.setDescription("The default field configuration");
        }
    }

    public void setDescription(FieldLayoutItem fieldLayoutItem, String description) {
        String descriptionToSet = StringUtils.isBlank((CharSequence)description) ? null : description;
        FieldLayoutItemImpl modified = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setFieldDescription(descriptionToSet).build();
        this.updateFieldLayoutItem(fieldLayoutItem, modified);
    }

    public void setRendererType(FieldLayoutItem fieldLayoutItem, String rendererType) {
        OrderableField field = fieldLayoutItem.getOrderableField();
        if (!this.getHackyFieldRendererRegistry().shouldOverrideDefaultRenderers(field) && !this.getFieldManager().isRenderableField((Field)field)) {
            throw new IllegalArgumentException("Trying to set a renderer on a field that is not renderable.");
        }
        FieldLayoutItemImpl modified = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setRendererType(rendererType).build();
        this.updateFieldLayoutItem(fieldLayoutItem, modified);
    }

    @Override
    public String getType() {
        return "default";
    }

    public void show(FieldLayoutItem fieldLayoutItem) {
        OrderableField field = fieldLayoutItem.getOrderableField();
        if (!this.getFieldManager().isHideableField((Field)field)) {
            throw new IllegalArgumentException("Trying to set a field '" + field.getId() + "' to be shown, but that field cannot ever be hidden.");
        }
        FieldLayoutItemImpl modified = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setHidden(false).build();
        this.updateFieldLayoutItem(fieldLayoutItem, modified);
    }

    public void hide(FieldLayoutItem fieldLayoutItem) {
        OrderableField field;
        FieldManager fieldManager = this.getFieldManager();
        if (!fieldManager.isHideableField((Field)(field = fieldLayoutItem.getOrderableField()))) {
            throw new IllegalArgumentException("Trying to hide a field that is not hideable.");
        }
        FieldLayoutItemImpl modified = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setHidden(true).setRequired(fieldManager.isMandatoryField((Field)field)).build();
        this.updateFieldLayoutItem(fieldLayoutItem, modified);
    }

    public void makeRequired(FieldLayoutItem fieldLayoutItem) {
        if (!this.getFieldManager().isRequirableField((Field)fieldLayoutItem.getOrderableField())) {
            throw new IllegalArgumentException("Trying to require a field that is not requireable.");
        }
        FieldLayoutItemImpl modified = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setHidden(false).setRequired(true).build();
        this.updateFieldLayoutItem(fieldLayoutItem, modified);
    }

    public void makeOptional(FieldLayoutItem fieldLayoutItem) {
        OrderableField field = fieldLayoutItem.getOrderableField();
        if (!this.getFieldManager().isRequirableField((Field)field)) {
            throw new IllegalArgumentException("Trying to make field '" + field.getId() + "' optional, but that field cannot ever have been required.");
        }
        FieldLayoutItemImpl modified = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setRequired(false).build();
        this.updateFieldLayoutItem(fieldLayoutItem, modified);
    }

    private void updateFieldLayoutItem(FieldLayoutItem fieldLayoutItem, FieldLayoutItem modified) {
        List<FieldLayoutItem> internalList = this.getInternalList();
        int pos = internalList.indexOf(fieldLayoutItem);
        internalList.set(pos, modified);
        this.fieldLayoutItemByFieldId.put(modified.getOrderableField().getId(), modified);
    }

    public void setName(String name) {
        this.setInternalName(name);
    }

    public void setDescription(String description) {
        this.setInternalDescription(description);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 29 * this.getInternalList().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldLayout)) {
            return false;
        }
        FieldLayout fieldLayout = (FieldLayout)o;
        return super.equals(o) && this.getFieldLayoutItems().equals(fieldLayout.getFieldLayoutItems());
    }
}

