/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.AttachmentFileNameCreationDateComparator;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBeanConverter;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentRenderedJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.util.BackwardCompatibleTemporaryAttachmentUtil;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;
import webwork.config.Configuration;

public class AttachmentSystemField
extends AbstractOrderableField<List<String>>
implements HideableField,
RestAwareField {
    private static final Logger log = LoggerFactory.getLogger(AttachmentSystemField.class);
    public static final String FILETOCONVERT = "filetoconvert";
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final ThumbnailManager thumbnailManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final EmailFormatter emailFormatter;
    private final BackwardCompatibleTemporaryAttachmentUtil temporaryAttachmentUtil;
    private final AttachmentJsonBeanConverter attachmentJsonBeanConverter;

    public AttachmentSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, AttachmentManager attachmentManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, JiraBaseUrls jiraBaseUrls, ThumbnailManager thumbnailManager, DateTimeFormatterFactory dateTimeFormatterFactory, EmailFormatter emailFormatter, BackwardCompatibleTemporaryAttachmentUtil temporaryAttachmentUtil, AttachmentJsonBeanConverter attachmentJsonBeanConverter) {
        super("attachment", "issue.field.attachment", templatingEngine, applicationProperties, authenticationContext, permissionManager, null);
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.thumbnailManager = thumbnailManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.emailFormatter = emailFormatter;
        this.temporaryAttachmentUtil = temporaryAttachmentUtil;
        this.attachmentJsonBeanConverter = attachmentJsonBeanConverter;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        Long maxSizeRaw = Long.valueOf(Configuration.getString((String)"webwork.multipart.maxSize"));
        velocityParams.put("maxSizeRaw", maxSizeRaw);
        velocityParams.put("maxSize", FileSize.format((Long)maxSizeRaw));
        String formToken = (String)operationContext.getFieldValuesHolder().get("formToken");
        List tempFiles = formToken != null ? this.temporaryAttachmentUtil.getTemporaryWebAttachmentsByFormToken(formToken) : Collections.emptyList();
        Object checkedFiles = operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put("tempFiles", tempFiles);
        if (checkedFiles != null) {
            velocityParams.put("checkedFiles", checkedFiles);
        }
        return this.renderTemplate("attachment-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, List<String> value, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    public boolean isShown(Issue issue) {
        boolean hasCreateAttachmentPermission = issue.isCreated() ? this.permissionManager.hasPermission(ProjectPermissions.CREATE_ATTACHMENTS, issue, this.getAuthenticationContext().getUser()) : this.permissionManager.hasPermission(ProjectPermissions.CREATE_ATTACHMENTS, issue.getProjectObject(), this.getAuthenticationContext().getUser(), true);
        return hasCreateAttachmentPermission && this.attachmentManager.attachmentsEnabled();
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        List tempAttachmentIds = (List)fieldValuesHolder.get(this.getId());
        if (tempAttachmentIds == null || tempAttachmentIds.isEmpty()) {
            return;
        }
        if (!this.temporaryAttachmentUtil.allAttachmentsExists(tempAttachmentIds)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("attachment.temporary.id.session.time.out"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public List<String> getDefaultValue(Issue issue) {
        return null;
    }

    public void createValue(Issue issue, List<String> value) {
        this.addAttachmentIgnoreErrors(issue, value);
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        issueChangeHolder.addChangeItems(this.addAttachmentIgnoreErrors(issue, (List)modifiedValue.getNewValue()));
    }

    private List<ChangeItemBean> addAttachmentIgnoreErrors(Issue issue, List<String> tempAttachmentIds) {
        if (tempAttachmentIds == null || tempAttachmentIds.isEmpty()) {
            return Collections.emptyList();
        }
        ApplicationUser currentUser = this.getAuthenticationContext().getUser();
        AttachmentsBulkOperationResult<ChangeItemBean> convertResult = this.temporaryAttachmentUtil.convertTemporaryAttachments(currentUser, issue, tempAttachmentIds);
        if (!convertResult.getErrors().isEmpty()) {
            String errors = Joiner.on((String)", ").join((Iterable)convertResult.getErrors());
            log.warn(String.format("There were errors while converting temporary attachments: %s", errors));
        }
        return convertResult.getResults();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            issue.setExternalFieldValue(this.getId(), fieldValueHolder.get(this.getId()));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public boolean hasValue(Issue issue) {
        return false;
    }

    public List<String> getValueFromParams(Map params) throws FieldValidationException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        if (params.containsKey(FILETOCONVERT)) {
            return Arrays.asList((Object[])params.get(FILETOCONVERT));
        }
        return Lists.newArrayList();
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"attachment", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        List comments = this.attachmentManager.getAttachments(issue, (Comparator)new AttachmentFileNameCreationDateComparator(this.getAuthenticationContext().getLocale()));
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)this.attachmentJsonBeanConverter.shortBeans((Collection)comments)));
        if (renderedVersionRequired) {
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)AttachmentRenderedJsonBean.shortBeans((Collection)comments, (JiraBaseUrls)this.jiraBaseUrls, (ThumbnailManager)this.thumbnailManager, (DateTimeFormatterFactory)this.dateTimeFormatterFactory, (ApplicationUser)this.authenticationContext.getUser(), (EmailFormatter)this.emailFormatter)));
        }
        return fieldJsonRepresentation;
    }
}

