/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractSingleValueCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.NavigatorConversionResult;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.List;

public class SelectCustomFieldSearchInputTransformer
extends AbstractSingleValueCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final CustomField customField;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final QueryContextConverter queryContextConverter;
    private final JqlOperandResolver jqlOperandResolver;

    public SelectCustomFieldSearchInputTransformer(CustomField field, ClauseNames clauseNames, String urlParameterName, JqlSelectOptionsUtil jqlSelectOptionsUtil, QueryContextConverter queryContextConverter, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper) {
        super(field, clauseNames, urlParameterName, customFieldInputHelper);
        this.clauseNames = (ClauseNames)Assertions.notNull((String)"clauseNames", (Object)clauseNames);
        this.queryContextConverter = (QueryContextConverter)Assertions.notNull((String)"queryContextConverter", (Object)queryContextConverter);
        this.jqlSelectOptionsUtil = (JqlSelectOptionsUtil)Assertions.notNull((String)"jqlSelectOptionsUtil", (Object)jqlSelectOptionsUtil);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.customField = (CustomField)Assertions.notNull((String)"field", (Object)field);
    }

    Clause createSearchClause(ApplicationUser user, String value) {
        if (value != null && !value.equals("-1")) {
            String transformedValue = value;
            Long longValue = OptionUtils.safeParseLong((String)value);
            Option option = this.jqlSelectOptionsUtil.getOptionById(longValue);
            if (option != null) {
                transformedValue = option.getValue();
            }
            return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.EQUALS, transformedValue);
        }
        return null;
    }

    protected CustomFieldParams getParamsFromSearchRequest(ApplicationUser user, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            SimpleNavigatorCollectorVisitor visitor = this.createSimpleNavigatorCollectingVisitor();
            query.getWhereClause().accept((ClauseVisitor)visitor);
            if (!visitor.isValid()) {
                return null;
            }
            List clauses = visitor.getClauses();
            if (clauses.size() != 1) {
                return null;
            }
            TerminalClause clause = (TerminalClause)clauses.get(0);
            Operator operator = clause.getOperator();
            if (operator != Operator.EQUALS && operator != Operator.IS && operator != Operator.IN) {
                return null;
            }
            List literals = this.jqlOperandResolver.getValues(user, clause.getOperand(), clause);
            if (literals == null || literals.size() != 1) {
                return null;
            }
            QueryLiteral literal = (QueryLiteral)literals.get(0);
            if (literal.isEmpty()) {
                return null;
            }
            QueryContext queryContext = this.queryContextConverter.getQueryContext(searchContext);
            List<Option> options = this.jqlSelectOptionsUtil.getOptions(this.customField, queryContext, literal, true);
            if (options.size() > 1) {
                return null;
            }
            if (options.size() == 0) {
                return null;
            }
            Option option = options.get(0);
            return new CustomFieldParamsImpl(this.customField, Collections.singleton(option.getOptionId().toString()));
        }
        return null;
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        NavigatorConversionResult result = this.convertForNavigator(query);
        if (result.fitsNavigator() && result.getValue() != null) {
            return this.getOptionsFromValue(result.getValue(), searchContext).size() <= 1;
        }
        return result.fitsNavigator();
    }

    private List<Option> getOptionsFromValue(SingleValueOperand operand, SearchContext searchContext) {
        String stringValue = operand.getStringValue();
        return this.jqlSelectOptionsUtil.getOptions(this.customField, this.queryContextConverter.getQueryContext(searchContext), new QueryLiteral((Operand)operand, stringValue), true);
    }

    SimpleNavigatorCollectorVisitor createSimpleNavigatorCollectingVisitor() {
        return new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
    }
}

