/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryBatch;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.query.IssueIdCollector;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Collector;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeHistoryManager
implements ChangeHistoryManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultChangeHistoryManager.class);
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private final PermissionManager permissionManager;
    private final ComponentLocator componentLocator;
    private final UserManager userManager;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private static final String ISSUEID_FIELD = "issueid";
    private static final List<String> FIELDS_TO_SELECT = ImmutableList.of((Object)"issueid");
    public static final String HISTORY_METADATA_KEY = "history_metadata";

    public DefaultChangeHistoryManager(IssueManager issueManager, OfBizDelegator ofBizDelegator, PermissionManager permissionManager, ComponentLocator componentLocator, UserManager userManager, JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.issueManager = issueManager;
        this.userManager = userManager;
        this.ofBizDelegator = ofBizDelegator;
        this.permissionManager = permissionManager;
        this.componentLocator = componentLocator;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    @Nullable
    public ChangeHistory getChangeHistoryById(Long changeGroupId) {
        Assertions.notNull((String)"changeGroupId", (Object)changeGroupId);
        GenericValue changeHistoryGV = this.ofBizDelegator.findById("ChangeGroup", changeGroupId);
        return changeHistoryGV == null ? null : new ChangeHistory(changeHistoryGV, this.issueManager, this.userManager);
    }

    public List<ChangeHistory> getChangeHistories(Issue issue) {
        return this.getAllChangeHistories((Iterable<Issue>)ImmutableList.of((Object)issue));
    }

    @Nonnull
    public List<ChangeHistory> getChangeHistoriesSince(@Nonnull Issue issue, @Nonnull Date since) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"since", (Object)since);
        EntityExpr issueCondition = new EntityExpr("issue", EntityOperator.EQUALS, (Object)issue.getId());
        EntityExpr dateCondition = new EntityExpr("created", EntityOperator.GREATER_THAN, (Object)new Timestamp(since.getTime()));
        EntityConditionList finalCondition = new EntityConditionList(Arrays.asList(issueCondition, dateCondition), EntityOperator.AND);
        List changeHistoriesSinceDate = this.ofBizDelegator.findByCondition("ChangeGroup", (EntityCondition)finalCondition, null, (List)ImmutableList.of((Object)"created DESC", (Object)"id ASC"));
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)changeHistoriesSinceDate, (Function)new Function<GenericValue, ChangeHistory>(){

            public ChangeHistory apply(@Nullable GenericValue genericValue) {
                return genericValue != null ? new ChangeHistory(genericValue, DefaultChangeHistoryManager.this.issueManager, DefaultChangeHistoryManager.this.userManager) : null;
            }
        }));
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Issue issue, ApplicationUser remoteUser) {
        return this.getAllChangeHistories((Iterable<Issue>)ImmutableList.of((Object)issue));
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Iterable<Issue> issues, ApplicationUser remoteUser) {
        return this.getAllChangeHistories(issues);
    }

    private List<ChangeHistory> getAllChangeHistories(Iterable<Issue> issues) {
        Assertions.notNull((String)"issues", issues);
        return ChangeHistoryBatch.createBatchForIssue(issues, this.ofBizDelegator, this.issueManager, this.userManager).asList();
    }

    public List<ChangeItemBean> getChangeItemsForField(Issue issue, String changeItemFieldName) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notBlank((String)"changeItemFieldName", (String)changeItemFieldName);
        if (issue.getId() == null) {
            return Collections.emptyList();
        }
        List changeItemsForFieldGVs = this.ofBizDelegator.findByAnd("ChangeGroupChangeItemView", (Map)ImmutableMap.of((Object)"issue", (Object)issue.getId(), (Object)"field", (Object)changeItemFieldName), (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        ArrayList<ChangeItemBean> changeItemsForField = new ArrayList<ChangeItemBean>(changeItemsForFieldGVs.size());
        for (GenericValue changeItemGV : changeItemsForFieldGVs) {
            changeItemsForField.add(new ChangeItemBean(changeItemGV.getString("fieldtype"), changeItemGV.getString("field"), changeItemGV.getString("oldvalue"), changeItemGV.getString("oldstring"), changeItemGV.getString("newvalue"), changeItemGV.getString("newstring"), changeItemGV.getTimestamp("created")));
        }
        return changeItemsForField;
    }

    public List<ChangeHistoryItem> getAllChangeItems(Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        Project project = issue.getProjectObject();
        if (issue.getId() == null || project == null) {
            return Collections.emptyList();
        }
        List changeItemsGVs = this.ofBizDelegator.findByAnd("ChangeGroupChangeItemView", (Map)ImmutableMap.of((Object)"issue", (Object)issue.getId()), (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        HashMap fieldsPerChangeGroup = Maps.newHashMap();
        ArrayList builders = Lists.newArrayList();
        for (GenericValue changeItemGV : changeItemsGVs) {
            ChangeHistoryItem.Builder builder;
            Long changeGroupId = changeItemGV.getLong("changegroupid");
            String fieldName = changeItemGV.getString("field");
            HashMap<String, ChangeHistoryItem.Builder> buildersPerField = (HashMap<String, ChangeHistoryItem.Builder>)fieldsPerChangeGroup.get(changeGroupId);
            if (buildersPerField == null) {
                buildersPerField = new HashMap<String, ChangeHistoryItem.Builder>();
                fieldsPerChangeGroup.put(changeGroupId, buildersPerField);
            }
            if (buildersPerField.containsKey(fieldName)) {
                builder = (ChangeHistoryItem.Builder)buildersPerField.get(fieldName);
                builder.changedFrom(changeItemGV.getString("oldstring"), changeItemGV.getString("oldvalue"));
                builder.to(changeItemGV.getString("newstring"), changeItemGV.getString("newvalue"));
                continue;
            }
            builder = new ChangeHistoryItem.Builder().withId(changeItemGV.getLong("changeitemid")).inChangeGroup(changeGroupId).inProject(project.getId()).forIssue(issue.getId(), issue.getKey()).field(changeItemGV.getString("field")).on(changeItemGV.getTimestamp("created")).changedFrom(changeItemGV.getString("oldstring"), changeItemGV.getString("oldvalue")).to(changeItemGV.getString("newstring"), changeItemGV.getString("newvalue")).byUser(changeItemGV.getString("author"));
            buildersPerField.put(fieldName, builder);
            builders.add(builder);
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)builders, (Function)new Function<ChangeHistoryItem.Builder, ChangeHistoryItem>(){

            public ChangeHistoryItem apply(ChangeHistoryItem.Builder builder) {
                return builder.build();
            }
        }));
    }

    public Issue findMovedIssue(String originalKey) {
        return this.issueManager.findMovedIssue(originalKey);
    }

    public Collection<String> getPreviousIssueKeys(Long issueId) {
        Set issueKeys = this.issueManager.getAllIssueKeys(issueId);
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)issueKeys, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)issue.getKey()))));
    }

    public Collection<String> getPreviousIssueKeys(String issueKey) {
        Assertions.notNull((String)"issueKey", (Object)issueKey);
        MutableIssue theIssue = this.issueManager.getIssueObject(issueKey);
        if (theIssue == null) {
            return Collections.emptySet();
        }
        return this.getPreviousIssueKeys(theIssue.getId());
    }

    public Collection<Issue> findUserHistory(ApplicationUser remoteUser, Collection<String> userkeys, int maxResults) {
        Collection projectObjects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, remoteUser);
        ArrayList<Long> projectIds = new ArrayList<Long>(projectObjects.size());
        for (Project project : projectObjects) {
            projectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, userkeys, projectIds, maxResults);
    }

    public Collection<Issue> findUserHistory(ApplicationUser remoteUser, Collection<String> userkeys, Collection<Project> projects, int maxResults) {
        ApplicationUser user = remoteUser;
        ArrayList<Long> filteredProjectIds = new ArrayList<Long>(projects.size());
        for (Project project : projects) {
            if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)) continue;
            filteredProjectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, userkeys, filteredProjectIds, maxResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Map<String, String> findAllPossibleValues(String field) {
        Assertions.notNull((String)"field", (Object)field);
        OfBizListIterator iterator = this.getAllChangeItemsContainingValueAndString(field);
        if (iterator != null) {
            try {
                Map<String, String> map = this.collectFieldValues(iterator);
                return map;
            }
            finally {
                iterator.close();
            }
        }
        return Collections.emptyMap();
    }

    @Nullable
    private OfBizListIterator getAllChangeItemsContainingValueAndString(String field) {
        EntityExpr condition = new EntityExpr((EntityCondition)new EntityFieldMap((Map)ImmutableMap.of((Object)"field", (Object)field), EntityOperator.AND), EntityOperator.AND, (EntityCondition)new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr((EntityCondition)new EntityExpr("oldvalue", EntityOperator.NOT_EQUAL, null), EntityOperator.AND, (EntityCondition)new EntityExpr("oldstring", EntityOperator.NOT_EQUAL, null)), (Object)new EntityExpr((EntityCondition)new EntityExpr("newvalue", EntityOperator.NOT_EQUAL, null), EntityOperator.AND, (EntityCondition)new EntityExpr("newstring", EntityOperator.NOT_EQUAL, null))), EntityOperator.OR));
        try {
            return this.ofBizDelegator.findListIteratorByCondition("ChangeItem", (EntityCondition)condition, null, (Collection)ImmutableList.of((Object)"oldstring", (Object)"oldvalue", (Object)"newstring", (Object)"newvalue"), (List)ImmutableList.of((Object)"asc"), null);
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve values for " + field, (Throwable)e);
            return null;
        }
    }

    public void removeAllChangeItems(Issue issue) {
        ImmutableMap params = ImmutableMap.of((Object)"issue", (Object)issue.getId());
        List changeGroups = this.ofBizDelegator.findByAnd("ChangeGroup", (Map)params);
        for (GenericValue changeGroup : changeGroups) {
            Long changeGroupId = changeGroup.getLong("id");
            this.ofBizDelegator.removeByAnd("ChangeItem", (Map)ImmutableMap.of((Object)"group", (Object)changeGroupId));
            this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.CHANGE_HISTORY_PROPERTY.getDbEntityName(), changeGroupId);
        }
        this.ofBizDelegator.removeByAnd("ChangeGroup", (Map)params);
    }

    private Map<String, String> collectFieldValues(OfBizListIterator genericValuesIterator) {
        MapBuilder builder = MapBuilder.newBuilder();
        for (GenericValue gv : genericValuesIterator) {
            if (StringUtils.isNotBlank((String)gv.getString("oldstring")) && StringUtils.isNotBlank((String)gv.getString("oldvalue"))) {
                builder.add((Object)gv.getString("oldstring").toLowerCase(), (Object)gv.getString("oldvalue").toLowerCase());
            }
            if (!StringUtils.isNotBlank((String)gv.getString("newstring")) || !StringUtils.isNotBlank((String)gv.getString("newvalue"))) continue;
            builder.add((Object)gv.getString("newstring").toLowerCase(), (Object)gv.getString("newvalue").toLowerCase());
        }
        return builder.toMap();
    }

    Collection<Issue> doFindUserHistory(ApplicationUser remoteUser, Collection<String> userkeys, Collection<Long> projects, int maxResults) {
        SearchResults searchResults;
        Query query;
        if (projects.isEmpty()) {
            return Collections.emptyList();
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
        if (userkeys == null) {
            builder.project().in(projects.toArray(new Long[projects.size()])).endWhere().orderBy().updatedDate(SortOrder.DESC);
            query = builder.buildQuery();
        } else {
            Collection<Long> issueIds = this.findMostRecentlyUpdatedIssueIds(maxResults, userkeys, projects, remoteUser);
            if (issueIds.isEmpty()) {
                return Collections.emptyList();
            }
            builder.issue().in(issueIds.toArray(new Long[issueIds.size()])).endWhere().orderBy().updatedDate(SortOrder.DESC);
            query = builder.buildQuery();
        }
        SearchProvider searchProvider = (SearchProvider)this.componentLocator.getComponentInstanceOfType(SearchProvider.class);
        try {
            searchResults = searchProvider.search(query, remoteUser, new PagerFilter(maxResults));
        }
        catch (SearchException e) {
            log.error("Error running query '" + query + "'");
            return Collections.emptyList();
        }
        List issues = searchResults.getIssues();
        Comparator<Issue> comparator = new Comparator<Issue>(){

            @Override
            public int compare(Issue o1, Issue o2) {
                return o1.getCreated().compareTo(o2.getCreated());
            }
        };
        return ImmutableSortedSet.copyOf((Comparator)comparator, (Collection)issues).asList();
    }

    private Collection<Long> findMostRecentlyUpdatedIssueIds(int maxResults, Collection<String> userkeys, Collection<Long> projects, ApplicationUser remoteUser) {
        return this.findMostRecentlyUpdatedIssueIdsByUsers(projects, userkeys, maxResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> findMostRecentlyUpdatedIssueIdsByUsers(Collection<Long> projects, @Nonnull Collection<String> userkeys, int maxResults) {
        LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
        OfBizListIterator changeGroupIssueViewIt = null;
        OfBizListIterator actionIssueViewIt = null;
        try {
            EntityConditionList entityCondition = new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("project", EntityOperator.IN, projects), (Object)new EntityExpr("author", EntityOperator.IN, userkeys)), EntityOperator.AND);
            EntityFindOptions entityFindOptions = EntityFindOptions.findOptions().maxResults(maxResults);
            changeGroupIssueViewIt = this.ofBizDelegator.findListIteratorByCondition("ChangeGroupIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), entityFindOptions);
            issueIds.addAll(this.extractIssueIds(maxResults, changeGroupIssueViewIt));
            actionIssueViewIt = this.ofBizDelegator.findListIteratorByCondition("ActionIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), entityFindOptions);
            issueIds.addAll(this.extractIssueIds(maxResults, actionIssueViewIt));
            LinkedHashSet<Long> linkedHashSet = issueIds;
            return linkedHashSet;
        }
        finally {
            if (actionIssueViewIt != null) {
                actionIssueViewIt.close();
            }
            if (changeGroupIssueViewIt != null) {
                changeGroupIssueViewIt.close();
            }
        }
    }

    private Collection<Long> findMostRecentlyUpdatedIssueIds(Collection<Long> projects, int maxResults, ApplicationUser remoteUser) {
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
        builder.project().in(projects.toArray(new Long[projects.size()])).endWhere().orderBy().updatedDate(SortOrder.DESC);
        Query query = builder.buildQuery();
        SearchProvider searchProvider = (SearchProvider)this.componentLocator.getComponentInstanceOfType(SearchProvider.class);
        try {
            IssueIdCollector issueIdCollector = this.getIssueIdCollector();
            searchProvider.searchAndSortOverrideSecurity(query, remoteUser, (Collector)issueIdCollector, new PagerFilter(0, maxResults));
            return Lists.transform((List)Lists.newArrayList(issueIdCollector.getIssueIds()), (Function)new Function<String, Long>(){

                public Long apply(@Nullable String input) {
                    return Long.valueOf(input);
                }
            });
        }
        catch (SearchException e) {
            log.error("Error running query '" + query + "'");
            return Collections.emptyList();
        }
        catch (IOException e) {
            log.error("Error running query '" + query + "'");
            return Collections.emptyList();
        }
    }

    @VisibleForTesting
    IssueIdCollector getIssueIdCollector() {
        SearchProviderFactory searchProviderFactory = (SearchProviderFactory)this.componentLocator.getComponentInstanceOfType(SearchProviderFactory.class);
        return new IssueIdCollector(searchProviderFactory.getSearcher("issues").getIndexReader());
    }

    private Set<Long> extractIssueIds(int maxResults, OfBizListIterator iterator) {
        LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
        GenericValue issueIdGV = iterator.next();
        for (int issuesLeft = maxResults; issueIdGV != null && issuesLeft > 0; --issuesLeft) {
            issueIds.add(issueIdGV.getLong(ISSUEID_FIELD));
            issueIdGV = iterator.next();
        }
        return issueIds;
    }
}

