/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.strategy;

import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.store.strategy.StoreOperationStrategy;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.base.Functions;

public class FailoverOnMissingOperationStrategy
implements StoreOperationStrategy {
    private final StreamAttachmentStore primaryStore;
    private final StreamAttachmentStore secondaryStore;

    public FailoverOnMissingOperationStrategy(StreamAttachmentStore primaryAttachmentStore, StreamAttachmentStore secondaryAttachmentStore) {
        this.primaryStore = primaryAttachmentStore;
        this.secondaryStore = secondaryAttachmentStore;
    }

    @Override
    public <V> Promise<V> perform(final com.atlassian.util.concurrent.Function<StreamAttachmentStore, Promise<V>> operation) {
        return ((Promise)operation.get((Object)this.primaryStore)).fold(new Function<Throwable, Promise<V>>(){

            public Promise<V> apply(Throwable throwableFromPrimary) {
                if (throwableFromPrimary instanceof NoAttachmentDataException) {
                    return (Promise)operation.get((Object)FailoverOnMissingOperationStrategy.this.secondaryStore);
                }
                return Promises.rejected((Throwable)throwableFromPrimary);
            }
        }, new Function<V, Promise<V>>(){

            public Promise<V> apply(V input) {
                operation.get((Object)FailoverOnMissingOperationStrategy.this.secondaryStore);
                return Promises.promise(input);
            }
        }).flatMap(Functions.identity());
    }
}

