/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.store.strategy.StoreOperationStrategy;
import com.atlassian.jira.issue.attachment.store.strategy.get.AttachmentGetStrategy;
import com.atlassian.jira.issue.attachment.store.strategy.move.MoveTemporaryAttachmentStrategy;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DualSendingAttachmentStore
implements StreamAttachmentStore {
    private final StreamAttachmentStore primaryAttachmentStore;
    private final StreamAttachmentStore secondaryAttachmentStore;
    private final AttachmentGetStrategy attachmentGetStrategy;
    private final MoveTemporaryAttachmentStrategy moveTemporaryAttachmentStrategy;
    private final StoreOperationStrategy attachmentOperationStrategy;

    public DualSendingAttachmentStore(StreamAttachmentStore primaryAttachmentStore, StreamAttachmentStore secondaryAttachmentStore, AttachmentGetStrategy attachmentGetStrategy, MoveTemporaryAttachmentStrategy moveTemporaryAttachmentStrategy, StoreOperationStrategy attachmentOperationStrategy) {
        this.primaryAttachmentStore = primaryAttachmentStore;
        this.secondaryAttachmentStore = secondaryAttachmentStore;
        this.attachmentGetStrategy = attachmentGetStrategy;
        this.moveTemporaryAttachmentStrategy = moveTemporaryAttachmentStrategy;
        this.attachmentOperationStrategy = attachmentOperationStrategy;
    }

    public Promise<StoreAttachmentResult> putAttachment(final StoreAttachmentBean storeAttachmentBean) {
        return this.primaryAttachmentStore.putTemporaryAttachment(storeAttachmentBean.getStream(), storeAttachmentBean.getSize().longValue()).flatMap((Function)new Function<TemporaryAttachmentId, Promise<Unit>>(){

            public Promise<Unit> apply(TemporaryAttachmentId temporaryAttachmentId) {
                return DualSendingAttachmentStore.this.moveTemporaryToAttachment(temporaryAttachmentId, storeAttachmentBean.getAttachmentKey());
            }
        }).map(Functions.constant((Object)StoreAttachmentResult.created()));
    }

    public <A> Promise<A> getAttachment(AttachmentKey attachmentKey, final com.atlassian.util.concurrent.Function<InputStream, A> inputStreamProcessor) {
        return this.getAttachmentData(attachmentKey, new com.atlassian.util.concurrent.Function<AttachmentGetData, A>(){

            public A get(AttachmentGetData store) {
                return inputStreamProcessor.get((Object)store.getInputStream());
            }
        });
    }

    public <A> Promise<A> getAttachmentData(AttachmentKey attachmentKey, com.atlassian.util.concurrent.Function<AttachmentGetData, A> attachmentGetDataProcessor) {
        return this.attachmentGetStrategy.getAttachmentData(attachmentKey, attachmentGetDataProcessor);
    }

    public Promise<Unit> moveAttachment(final AttachmentKey oldAttachmentKey, final AttachmentKey newAttachmentKey) {
        return this.attachmentOperationStrategy.perform(new com.atlassian.util.concurrent.Function<StreamAttachmentStore, Promise<Unit>>(){

            public Promise<Unit> get(StreamAttachmentStore store) {
                return store.moveAttachment(oldAttachmentKey, newAttachmentKey);
            }
        });
    }

    public Promise<Unit> copyAttachment(final AttachmentKey sourceAttachmentKey, final AttachmentKey newAttachmentKey) {
        return this.attachmentOperationStrategy.perform(new com.atlassian.util.concurrent.Function<StreamAttachmentStore, Promise<Unit>>(){

            public Promise<Unit> get(StreamAttachmentStore store) {
                return store.copyAttachment(sourceAttachmentKey, newAttachmentKey);
            }
        });
    }

    public Promise<Unit> deleteAttachment(final AttachmentKey attachmentKey) {
        return this.attachmentOperationStrategy.perform(new com.atlassian.util.concurrent.Function<StreamAttachmentStore, Promise<Unit>>(){

            public Promise<Unit> get(StreamAttachmentStore store) {
                return store.deleteAttachment(attachmentKey);
            }
        });
    }

    public Promise<TemporaryAttachmentId> putTemporaryAttachment(InputStream inputStream, long size) {
        return this.primaryAttachmentStore.putTemporaryAttachment(inputStream, size);
    }

    public Promise<Unit> moveTemporaryToAttachment(TemporaryAttachmentId temporaryAttachmentId, AttachmentKey destinationKey) {
        return this.moveTemporaryAttachmentStrategy.moveTemporaryToAttachment(temporaryAttachmentId, destinationKey);
    }

    public Promise<Unit> deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        return this.primaryAttachmentStore.deleteTemporaryAttachment(temporaryAttachmentId);
    }

    public Promise<Boolean> exists(AttachmentKey attachmentKey) {
        return this.attachmentGetStrategy.exists(attachmentKey);
    }

    @Nonnull
    public Option<ErrorCollection> errors() {
        final Option secondaryStoreErrors = this.secondaryAttachmentStore.errors();
        return (Option)this.primaryAttachmentStore.errors().fold(Suppliers.ofInstance((Object)secondaryStoreErrors), (Function)new Function<ErrorCollection, Option<ErrorCollection>>(){

            public Option<ErrorCollection> apply(ErrorCollection input) {
                if (secondaryStoreErrors.isDefined()) {
                    ErrorCollection errorCollection = (ErrorCollection)secondaryStoreErrors.get();
                    input.addErrorCollection(errorCollection);
                }
                return Option.some((Object)input);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DualSendingAttachmentStore that = (DualSendingAttachmentStore)o;
        return this.attachmentGetStrategy.equals(that.attachmentGetStrategy) && this.moveTemporaryAttachmentStrategy.equals(that.moveTemporaryAttachmentStrategy) && this.primaryAttachmentStore.equals(that.primaryAttachmentStore) && this.secondaryAttachmentStore.equals(that.secondaryAttachmentStore) && this.attachmentOperationStrategy.equals(that.attachmentOperationStrategy);
    }

    public int hashCode() {
        int result = this.primaryAttachmentStore.hashCode();
        result = 31 * result + this.secondaryAttachmentStore.hashCode();
        result = 31 * result + this.attachmentGetStrategy.hashCode();
        result = 31 * result + this.moveTemporaryAttachmentStrategy.hashCode();
        result = 31 * result + this.attachmentOperationStrategy.hashCode();
        return result;
    }
}

