/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class StoreAttachmentBeanMapper {
    public StoreAttachmentBean mapToBean(Attachment metadata, InputStream source) {
        StoreAttachmentBean.Builder builder = new StoreAttachmentBean.Builder(source);
        return this.mapAttachmentToStoreBean(metadata, builder);
    }

    public Either<FileNotFoundException, StoreAttachmentBean> mapToBean(Attachment metadata, File source) {
        try {
            FileInputStream inputStream = new FileInputStream(source);
            StoreAttachmentBean.Builder builder = new StoreAttachmentBean.Builder((InputStream)inputStream);
            return Either.right((Object)this.mapAttachmentToStoreBean(metadata, builder));
        }
        catch (FileNotFoundException exception) {
            return Either.left((Object)exception);
        }
    }

    private StoreAttachmentBean mapAttachmentToStoreBean(Attachment metadata, StoreAttachmentBean.Builder builder) {
        return builder.withId(metadata.getId().longValue()).withFileName(metadata.getFilename()).withSize(metadata.getFilesize().longValue()).withIssueKey(metadata.getIssue().getKey()).withOriginalProjectKey(metadata.getIssue().getProjectObject().getOriginalKey()).build();
    }
}

