/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentAdapterImpl;
import com.atlassian.jira.issue.attachment.AttachmentDirectoryAccessor;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.WithDirectoryAccessorThumbnailAccessor;
import java.io.File;
import javax.annotation.Nonnull;

public class FileSystemThumbnailAccessor
extends WithDirectoryAccessorThumbnailAccessor {
    private static final String THUMBNAIL_DESIGNATION = "_thumb_";

    public FileSystemThumbnailAccessor(AttachmentDirectoryAccessor ada) {
        super(ada);
    }

    private static File getThumbnailFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, THUMBNAIL_DESIGNATION + attachment.getId() + ".png");
    }

    private static File getLegacyThumbnailFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, attachment.getId() + THUMBNAIL_DESIGNATION + attachment.getFilename());
    }

    @Override
    @Nonnull
    public File getThumbnailFile(@Nonnull Attachment attachment) {
        AttachmentAdapterImpl attachmentAdapter = AttachmentAdapterImpl.fromAttachment((Attachment)attachment);
        File thumbDir = this.getAttachmentDirectoryAccessor().getThumbnailDirectory(attachment.getIssueObject());
        return FileSystemThumbnailAccessor.getThumbnailFile((AttachmentStore.AttachmentAdapter)attachmentAdapter, thumbDir);
    }

    @Override
    @Nonnull
    public File getThumbnailFile(@Nonnull Issue issue, @Nonnull Attachment attachment) {
        AttachmentAdapterImpl attachmentAdapter = AttachmentAdapterImpl.fromAttachment((Attachment)attachment);
        File thumbDir = this.getAttachmentDirectoryAccessor().getThumbnailDirectory(issue);
        return FileSystemThumbnailAccessor.getThumbnailFile((AttachmentStore.AttachmentAdapter)attachmentAdapter, thumbDir);
    }

    @Override
    public File getLegacyThumbnailFile(@Nonnull Attachment attachment) {
        AttachmentAdapterImpl attachmentAdapter = AttachmentAdapterImpl.fromAttachment((Attachment)attachment);
        File thumbDir = this.getAttachmentDirectoryAccessor().getThumbnailDirectory(attachment.getIssueObject());
        return FileSystemThumbnailAccessor.getLegacyThumbnailFile((AttachmentStore.AttachmentAdapter)attachmentAdapter, thumbDir);
    }
}

