/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentDataBulkImport;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentRuntimeException;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.BulkAttachmentOperations;
import com.atlassian.jira.issue.attachment.ReadOnlyFileBasedAttachmentStore;
import com.atlassian.jira.issue.util.ConsumeAllAttachmentKeys;
import com.atlassian.jira.util.BoundedExecutorServiceWrapper;
import com.atlassian.jira.util.CallableFunction;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.util.concurrent.ExceptionPolicy;
import com.atlassian.util.concurrent.Promise;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class DefaultAttachmentDataBulkImport
implements AttachmentDataBulkImport {
    private final BulkAttachmentOperations bulkAttachmentOperations;
    private final AttachmentStore attachmentStore;
    private final IssueManager issueManager;

    public DefaultAttachmentDataBulkImport(BulkAttachmentOperations operations, AttachmentStore store, IssueManager im) {
        this.bulkAttachmentOperations = operations;
        this.attachmentStore = store;
        this.issueManager = im;
    }

    public void importAttachmentDataFrom(ReadOnlyFileBasedAttachmentStore source, int concurrency, Option<com.atlassian.util.concurrent.Effect<Attachment>> onCompleteAttachment) throws AttachmentRuntimeException {
        BoundedExecutorServiceWrapper executor = new BoundedExecutorServiceWrapper.Builder().withConcurrency(concurrency).withThreadPoolName("import-attachment").build();
        this.importAttachmentDataFrom(source, executor, onCompleteAttachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void importAttachmentDataFrom(final ReadOnlyFileBasedAttachmentStore source, final BoundedExecutorServiceWrapper executor, final Option<com.atlassian.util.concurrent.Effect<Attachment>> onCompleteAttachment) throws AttachmentRuntimeException {
        final AtomicReference<Option> abortCause = new AtomicReference<Option>(Option.none());
        final CallableFunction consumer = new CallableFunction((Function)new Function<Pair<Attachment, AttachmentKey>, Void>(){

            public Void get(Pair<Attachment, AttachmentKey> input) {
                final Promise op = DefaultAttachmentDataBulkImport.this.attachmentStore.putAttachment((Attachment)input.left(), source.getAttachmentFile((AttachmentKey)input.right())).fail((com.atlassian.util.concurrent.Effect)new com.atlassian.util.concurrent.Effect<Throwable>(){

                    public void apply(Throwable throwable) {
                        abortCause.set(Option.some((Object)throwable));
                    }
                });
                onCompleteAttachment.foreach((Effect)new Effect<com.atlassian.util.concurrent.Effect<Attachment>>(){

                    public void apply(com.atlassian.util.concurrent.Effect<Attachment> attachmentEffect) {
                        op.done(attachmentEffect);
                    }
                });
                return null;
            }
        }, (ExceptionPolicy)ExceptionPolicy.Policies.THROW);
        try {
            ConsumeAllAttachmentKeys.getAttachmentsWithKeys((EnclosedIterable)this.bulkAttachmentOperations.getAllAttachments(), (IssueManager)this.issueManager).foreach((Consumer)new Consumer<Pair<Attachment, AttachmentKey>>(){

                public void consume(@Nonnull Pair<Attachment, AttachmentKey> pair) {
                    Option currentAbortCause = (Option)abortCause.get();
                    if (!currentAbortCause.isEmpty()) {
                        Throwable throwable = (Throwable)currentAbortCause.get();
                        if (throwable instanceof AttachmentRuntimeException) {
                            throw (AttachmentRuntimeException)throwable;
                        }
                        throw new AttachmentRuntimeException(throwable);
                    }
                    executor.submit(consumer.apply(pair));
                }
            });
        }
        finally {
            executor.awaitTermination();
        }
    }
}

