/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentDirectoryAccessor;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeyMapper;
import com.atlassian.jira.issue.attachment.AttachmentKeys;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.AttachmentWriteException;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentBeanMapper;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.attachment.store.BackwardCompatibleStoreAdapter;
import com.atlassian.jira.issue.attachment.store.provider.CachedBackwardCompatibleStoreAdapterProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BackwardCompatibleAttachmentStore
implements AttachmentStore,
StreamAttachmentStore {
    private final AttachmentDirectoryAccessor directoryAccessor;
    private final ThumbnailAccessor thumbnailAccessor;
    private final StoreAttachmentBeanMapper storeAttachmentBeanMapper;
    private final CachedBackwardCompatibleStoreAdapterProvider backwardCompatibleStoreAdapterProvider;
    private final AttachmentKeyMapper attachmentKeyMapper;
    private final ProjectManager projectManager;

    public BackwardCompatibleAttachmentStore(@Nonnull AttachmentDirectoryAccessor directoryAccessor, @Nonnull ThumbnailAccessor thumbnailAccessor, @Nonnull StoreAttachmentBeanMapper storeAttachmentBeanMapper, @Nonnull CachedBackwardCompatibleStoreAdapterProvider backwardCompatibleStoreAdapterProvider, @Nonnull AttachmentKeyMapper attachmentKeyMapper, @Nonnull ProjectManager projectManager) {
        this.storeAttachmentBeanMapper = storeAttachmentBeanMapper;
        this.backwardCompatibleStoreAdapterProvider = backwardCompatibleStoreAdapterProvider;
        this.attachmentKeyMapper = attachmentKeyMapper;
        this.projectManager = projectManager;
        this.directoryAccessor = (AttachmentDirectoryAccessor)Preconditions.checkNotNull((Object)directoryAccessor);
        this.thumbnailAccessor = (ThumbnailAccessor)Preconditions.checkNotNull((Object)thumbnailAccessor);
    }

    @Nonnull
    public File getThumbnailDirectory(Issue issue) {
        return this.directoryAccessor.getThumbnailDirectory(issue);
    }

    public File getAttachmentDirectory(String issueKey) {
        return this.directoryAccessor.getAttachmentDirectory(issueKey);
    }

    public File getAttachmentDirectory(Issue issue, boolean createDirectory) {
        return this.directoryAccessor.getAttachmentDirectory(issue, createDirectory);
    }

    public File getTemporaryAttachmentDirectory() {
        return this.directoryAccessor.getTemporaryAttachmentDirectory();
    }

    public File getAttachmentDirectory(Issue issue) {
        return this.directoryAccessor.getAttachmentDirectory(issue);
    }

    public File getAttachmentDirectory(String attachmentDirectory, String projectKey, String issueKey) {
        return this.directoryAccessor.getAttachmentDirectory(attachmentDirectory, projectKey, issueKey);
    }

    public void checkValidAttachmentDirectory(Issue issue) throws AttachmentException {
        this.directoryAccessor.checkValidAttachmentDirectory(issue);
    }

    public void checkValidTemporaryAttachmentDirectory() throws AttachmentException {
        this.directoryAccessor.checkValidTemporaryAttachmentDirectory();
    }

    public File getAttachmentFile(AttachmentStore.AttachmentAdapter adapter, File attachmentDir) {
        return this.getBackwardCompatibleStoreAdapter().getAttachmentFile(adapter, attachmentDir);
    }

    @Nonnull
    public File getThumbnailFile(Attachment attachment) {
        return this.thumbnailAccessor.getThumbnailFile(attachment);
    }

    @Nonnull
    public File getThumbnailFile(Issue issue, Attachment attachment) {
        return this.thumbnailAccessor.getThumbnailFile(issue, attachment);
    }

    public File getLegacyThumbnailFile(Attachment attachment) {
        return this.thumbnailAccessor.getLegacyThumbnailFile(attachment);
    }

    public File getAttachmentFile(Issue issue, Attachment attachment) throws DataAccessException {
        return this.getAttachmentFile(attachment);
    }

    public File getAttachmentFile(Attachment attachment) throws DataAccessException {
        AttachmentKey attachmentKey = this.attachmentKeyMapper.fromAttachment(attachment);
        return this.getBackwardCompatibleStoreAdapter().getAttachmentFile(attachmentKey);
    }

    public Promise<Attachment> putAttachment(Attachment metadata, InputStream source) {
        StoreAttachmentBean storeAttachmentBean = this.storeAttachmentBeanMapper.mapToBean(metadata, source);
        return this.putAttachment(storeAttachmentBean).map(Functions.constant((Object)metadata));
    }

    public Promise<Attachment> putAttachment(final Attachment metadata, final File source) {
        return (Promise)this.storeAttachmentBeanMapper.mapToBean(metadata, source).fold((Function)new Function<FileNotFoundException, Promise<Attachment>>(){

            public Promise<Attachment> apply(FileNotFoundException fileNotFoundException) {
                return Promises.rejected((Throwable)new AttachmentWriteException("Failed to open file: " + source.getAbsolutePath(), (Throwable)fileNotFoundException));
            }
        }, (Function)new Function<StoreAttachmentBean, Promise<Attachment>>(){

            public Promise<Attachment> apply(StoreAttachmentBean storeAttachmentBean) {
                return BackwardCompatibleAttachmentStore.this.putAttachment(storeAttachmentBean).map(Functions.constant((Object)metadata));
            }
        });
    }

    public Promise<StoreAttachmentResult> putAttachment(StoreAttachmentBean storeAttachmentBean) {
        return this.getBackwardCompatibleStoreAdapter().putAttachment(storeAttachmentBean);
    }

    public <A> Promise<A> getAttachment(AttachmentKey attachmentKey, com.atlassian.util.concurrent.Function<InputStream, A> inputStreamProcessor) {
        return this.getBackwardCompatibleStoreAdapter().getAttachment(attachmentKey, inputStreamProcessor);
    }

    public <A> Promise<A> getAttachmentData(AttachmentKey attachmentKey, com.atlassian.util.concurrent.Function<AttachmentGetData, A> attachmentGetDataProcessor) {
        return this.getBackwardCompatibleStoreAdapter().getAttachmentData(attachmentKey, attachmentGetDataProcessor);
    }

    public Promise<Unit> moveAttachment(AttachmentKey oldAttachmentKey, AttachmentKey newAttachmentKey) {
        return this.getBackwardCompatibleStoreAdapter().moveAttachment(oldAttachmentKey, newAttachmentKey);
    }

    public Promise<Unit> copyAttachment(AttachmentKey sourceAttachmentKey, AttachmentKey newAttachmentKey) {
        return this.getBackwardCompatibleStoreAdapter().copyAttachment(sourceAttachmentKey, newAttachmentKey);
    }

    public Promise<Unit> deleteAttachment(AttachmentKey attachmentKey) {
        return this.getBackwardCompatibleStoreAdapter().deleteAttachment(attachmentKey);
    }

    public Promise<TemporaryAttachmentId> putTemporaryAttachment(InputStream inputStream, long size) {
        return this.getBackwardCompatibleStoreAdapter().putTemporaryAttachment(inputStream, size);
    }

    public Promise<Unit> moveTemporaryToAttachment(TemporaryAttachmentId temporaryAttachmentId, AttachmentKey destinationKey) {
        return this.getBackwardCompatibleStoreAdapter().moveTemporaryToAttachment(temporaryAttachmentId, destinationKey);
    }

    public Promise<Unit> deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        return this.getBackwardCompatibleStoreAdapter().deleteTemporaryAttachment(temporaryAttachmentId);
    }

    public Promise<Boolean> exists(AttachmentKey attachmentKey) {
        return this.getBackwardCompatibleStoreAdapter().exists(attachmentKey);
    }

    public <A> Promise<A> getAttachment(Attachment metaData, com.atlassian.util.concurrent.Function<InputStream, A> inputStreamProcessor) {
        AttachmentKey attachmentKey = this.attachmentKeyMapper.fromAttachment(metaData);
        return this.getAttachment(attachmentKey, inputStreamProcessor);
    }

    public Promise<Void> move(Attachment metaData, String newIssueKey) {
        AttachmentKey oldAttachmentKey = this.attachmentKeyMapper.fromAttachment(metaData);
        IssueKey ik = IssueKey.from((String)newIssueKey);
        Project project = this.projectManager.getProjectObjByKey(ik.getProjectKey());
        String originalProjectKey = project.getOriginalKey();
        AttachmentKey newAttachmentKey = AttachmentKeys.from((String)originalProjectKey, (String)newIssueKey, (String)oldAttachmentKey.getAttachmentFilename(), (Long)oldAttachmentKey.getAttachmentId());
        return this.moveAttachment(oldAttachmentKey, newAttachmentKey).map(this.unitToVoid());
    }

    private Function<? super Unit, ? extends Void> unitToVoid() {
        return new Function<Unit, Void>(){

            public Void apply(@Nullable Unit unit) {
                return null;
            }
        };
    }

    public Promise<Void> deleteAttachment(@Nonnull Attachment attachment) {
        AttachmentKey attachmentKey = this.attachmentKeyMapper.fromAttachment(attachment);
        return this.getBackwardCompatibleStoreAdapter().deleteAttachment(attachmentKey).map(this.unitToVoid());
    }

    public Promise<Void> deleteAttachmentContainerForIssue(@Nonnull Issue issue) {
        return this.getBackwardCompatibleStoreAdapter().deleteAttachmentContainerForIssue(issue).map(this.unitToVoid());
    }

    @Nonnull
    public Promise<Attachment> copy(@Nonnull Attachment originalAttachment, final @Nonnull Attachment metaData, @Nonnull String newIssueKey) {
        return this.getBackwardCompatibleStoreAdapter().copyAttachment(AttachmentKeys.from((Attachment)originalAttachment), AttachmentKeys.from((Attachment)metaData)).map((Function)new Function<Unit, Attachment>(){

            public Attachment apply(@Nullable Unit unit) {
                return metaData;
            }
        });
    }

    @Nonnull
    public Option<ErrorCollection> errors() {
        return this.getBackwardCompatibleStoreAdapter().errors();
    }

    private BackwardCompatibleStoreAdapter getBackwardCompatibleStoreAdapter() {
        return this.backwardCompatibleStoreAdapterProvider.provide();
    }
}

