/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.property.OfBizPluginIndexConfigurationManager;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.plugin.index.EntityPropertyIndexDocumentModuleDescriptor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachingPluginIndexConfigurationManager
implements PluginIndexConfigurationManager {
    private final OfBizPluginIndexConfigurationManager delegate;
    private final Cache<String, Iterable<PluginIndexConfiguration>> byEntityKeyCache;

    public CachingPluginIndexConfigurationManager(OfBizPluginIndexConfigurationManager delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.byEntityKeyCache = cacheManager.getCache(CachingPluginIndexConfigurationManager.class.getName() + ".cacheByEntityKey", (CacheLoader)new ByEntityKeyCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maxEntries(1000).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.byEntityKeyCache.removeAll();
    }

    @PluginEventListener
    public void onPluginUninstalled(PluginUninstalledEvent event) {
        this.remove(event.getPlugin().getKey());
    }

    @PluginEventListener
    public void onPluginRefreshed(PluginRefreshedEvent event) {
        this.remove(event.getPlugin().getKey());
    }

    @PluginEventListener
    public void onPluginUpgraded(PluginUpgradedEvent event) {
        this.remove(event.getPlugin().getKey());
    }

    @EventListener
    public void onComponentManagerStartedEvent(ComponentManagerStartedEvent ignore) {
        List epIndexModules = ComponentAccessor.getPluginAccessor().getEnabledModuleDescriptorsByClass(EntityPropertyIndexDocumentModuleDescriptor.class);
        for (EntityPropertyIndexDocumentModuleDescriptor epIndexModule : epIndexModules) {
            SafePluginPointAccess.safe((Function)new Function<EntityPropertyIndexDocumentModuleDescriptor, Void>(){

                public Void apply(EntityPropertyIndexDocumentModuleDescriptor input) {
                    input.init();
                    return null;
                }
            }).apply((Object)epIndexModule);
        }
    }

    @Override
    public Iterable<PluginIndexConfiguration> getDocumentsForEntity(@Nonnull String entityKey) {
        return (Iterable)this.byEntityKeyCache.get((Object)entityKey);
    }

    @Override
    public void put(@Nonnull String pluginKey, @Nonnull String moduleKey, @Nonnull IndexDocumentConfiguration document) {
        this.delegate.put(pluginKey, moduleKey, document);
        this.byEntityKeyCache.remove((Object)document.getEntityKey());
    }

    @Override
    public void remove(@Nonnull String pluginKey) {
        this.delegate.remove(pluginKey);
        this.byEntityKeyCache.removeAll();
    }

    private class ByEntityKeyCacheLoader
    implements CacheLoader<String, Iterable<PluginIndexConfiguration>> {
        private ByEntityKeyCacheLoader() {
        }

        @Nonnull
        public Iterable<PluginIndexConfiguration> load(@Nonnull String entityKey) {
            return ImmutableList.copyOf(CachingPluginIndexConfigurationManager.this.delegate.getDocumentsForEntity(entityKey));
        }
    }
}

