/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.BackgroundIndexListener;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexReconciler;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.util.IssueIdsIssueIterable;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueIndexHelper {
    private static final Logger log = LoggerFactory.getLogger(IssueIndexHelper.class);
    private final IssueManager issueManager;
    private final IssueIndexer issueIndexer;
    private final IssueFactory issueFactory;

    public IssueIndexHelper(IssueManager issueManager, IssueIndexer issueIndexer, IssueFactory issueFactory) {
        this.issueManager = issueManager;
        this.issueIndexer = issueIndexer;
        this.issueFactory = issueFactory;
    }

    public long[] getAllIssueIds() {
        return this.withIssueSearcher(new SearcherFunction<long[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] apply(IndexSearcher issueSearcher) throws IOException {
                IndexReader indexReader = issueSearcher.getIndexReader();
                try (TermEnum termEnum = indexReader.terms(new Term("issue_id", ""));){
                    Term term;
                    int i = 0;
                    long[] issueIds = new long[indexReader.numDocs()];
                    while ((term = termEnum.term()) != null && term.field() == "issue_id") {
                        String issueId = term.text();
                        issueIds = IssueIndexHelper.this.ensureCapacity(issueIds, i + 1);
                        issueIds[i] = Long.parseLong(issueId);
                        ++i;
                        if (termEnum.next()) continue;
                    }
                    long[] lArray = issueIds;
                    return lArray;
                }
            }
        });
    }

    @VisibleForTesting
    protected long[] ensureCapacity(long[] issueIds, int requiredSize) {
        if (issueIds.length < requiredSize) {
            int newSize = Math.max(requiredSize, issueIds.length + issueIds.length / 10);
            return Arrays.copyOf(issueIds, newSize);
        }
        return issueIds;
    }

    public void fixupConcurrentlyIndexedIssues(Context context, AccumulatingResultBuilder resultBuilder, BackgroundIndexListener backgroundIndexListener, IssueIndexingParams issueIndexingParams) {
        IssueIdsIssueIterable issueIterable = new IssueIdsIssueIterable(backgroundIndexListener.getUpdatedIssues(), this.issueManager);
        resultBuilder.add(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issueIterable, context, issueIndexingParams, true));
        resultBuilder.toResult().await();
        this.safelyRemoveOrphans(resultBuilder, backgroundIndexListener.getDeletedIssues());
        resultBuilder.toResult().await();
    }

    public void fixupIndexCorruptions(AccumulatingResultBuilder resultBuilder, IndexReconciler reconciler) {
        this.safelyAddMissing(resultBuilder, reconciler.getUnindexed());
        resultBuilder.toResult().await();
        log.debug("" + reconciler.getUnindexed().size() + " missing issues add to the index.");
        this.safelyRemoveOrphans(resultBuilder, reconciler.getOrphans());
        resultBuilder.toResult().await();
        log.debug("" + reconciler.getOrphans().size() + " deleted issues removed from the index.");
    }

    public void safelyAddMissing(final AccumulatingResultBuilder resultBuilder, final Collection<Long> unindexed) {
        this.withIssueSearcher(new SearcherFunction<Void>(){

            @Override
            public Void apply(IndexSearcher issueSearcher) {
                for (Long issueId : unindexed) {
                    try {
                        MutableIssue issue = IssueIndexHelper.this.issueManager.getIssueObject(issueId);
                        if (issue == null) continue;
                        TermQuery query = new TermQuery(new Term("issue_id", String.valueOf(issueId)));
                        TopDocs topDocs = issueSearcher.search((Query)query, 1);
                        if (topDocs.totalHits != 0) continue;
                        IssueObjectIssuesIterable issues = new IssueObjectIssuesIterable(Collections.singletonList(issue));
                        resultBuilder.add(IssueIndexHelper.this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issues, Contexts.nullContext(), true, true, false));
                    }
                    catch (IOException e) {
                        resultBuilder.add(new DefaultIndex.Failure(e));
                    }
                }
                return null;
            }
        });
    }

    public void safelyRemoveOrphans(final AccumulatingResultBuilder resultBuilder, final Collection<Long> orphans) {
        this.withIssueSearcher(new SearcherFunction<Void>(){

            @Override
            public Void apply(IndexSearcher issueSearcher) {
                for (Long issueId : orphans) {
                    try {
                        MutableIssue issue = IssueIndexHelper.this.issueManager.getIssueObject(issueId);
                        if (issue != null) continue;
                        TermQuery query = new TermQuery(new Term("issue_id", String.valueOf(issueId)));
                        TopDocs topDocs = issueSearcher.search((Query)query, 1);
                        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                            Document doc = issueSearcher.doc(scoreDoc.doc);
                            Issue issueToDelete = IssueIndexHelper.this.issueFactory.getIssue(doc);
                            IssueObjectIssuesIterable issues = new IssueObjectIssuesIterable(Collections.singletonList(issueToDelete));
                            resultBuilder.add(IssueIndexHelper.this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)issues, Contexts.nullContext()));
                        }
                    }
                    catch (IOException e) {
                        resultBuilder.add(new DefaultIndex.Failure(e));
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T withIssueSearcher(SearcherFunction<T> searcherFunction) {
        try (IndexSearcher issueSearcher = this.issueIndexer.openEntitySearcher(IndexDirectoryFactory.Name.ISSUE);){
            T result;
            T t = result = searcherFunction.apply(issueSearcher);
            return t;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private static interface SearcherFunction<T> {
        public T apply(IndexSearcher var1) throws IOException;
    }
}

