/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.instrumentation.Counter;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.concurrent.ResettableLazyReference;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.DelayCloseSearcher;
import com.atlassian.jira.index.DelayCloseable;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.LuceneVersion;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.index.WriterWrapper;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultIndexEngine
implements DefaultIndex.Engine {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexEngine.class);
    private final WriterReference writerReference;
    private final SearcherFactory searcherFactory;
    private final SearcherReference searcherReference;
    private final Configuration configuration;

    DefaultIndexEngine(@Nonnull Configuration configuration) {
        this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        this.searcherFactory = new SearcherFactoryImpl(configuration);
        this.searcherReference = new SearcherReference(this.searcherFactory);
        this.writerReference = new WriterReference(new DefaultWriterFactory());
    }

    DefaultIndexEngine(@Nonnull SearcherFactory searcherFactory, @Nullable Function<Index.UpdateMode, Writer> writerFactory, @Nonnull Configuration configuration) {
        this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        this.searcherFactory = (SearcherFactory)Assertions.notNull((String)"searcherFactory", (Object)searcherFactory);
        this.searcherReference = new SearcherReference(searcherFactory);
        this.writerReference = new WriterReference(writerFactory == null ? new DefaultWriterFactory() : writerFactory);
    }

    @Override
    @Nonnull
    public IndexSearcher getSearcher() {
        return (IndexSearcher)this.searcherReference.get(Index.UpdateMode.INTERACTIVE);
    }

    @Override
    public void clean() {
        this.close();
        try {
            IndexWriterConfig luceneConfig = new IndexWriterConfig(LuceneVersion.get(), this.configuration.getAnalyzer());
            luceneConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            new IndexWriter(this.configuration.getDirectory(), luceneConfig).close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void write(@Nonnull Index.Operation operation) throws IOException {
        try {
            ((Writer)this.writerReference.get(operation.mode())).getFlushPolicy().perform(operation, this.writerReference);
        }
        finally {
            this.searcherReference.close();
        }
    }

    @Override
    public void close() {
        this.writerReference.close();
        this.searcherReference.close();
        this.searcherFactory.release();
    }

    private static class IndexEngineThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);

        private IndexEngineThreadFactory() {
        }

        @Override
        @Nonnull
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread t = new Thread(runnable, "JiraIndexCommitThread-" + this.threadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    private class SearcherFactoryImpl
    implements SearcherFactory {
        private final Configuration configuration;
        private volatile IndexReader oldReader = null;

        SearcherFactoryImpl(Configuration configuration) {
            this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        }

        public IndexSearcher get() {
            try {
                IndexReader reader;
                block8: {
                    if (this.oldReader != null) {
                        try {
                            reader = this.reopenIndexReader(this.oldReader);
                            if (reader == this.oldReader) break block8;
                            try {
                                this.oldReader.close();
                            }
                            catch (AlreadyClosedException ace) {
                                log.debug("Tried to close an already closed reader.", (Throwable)ace);
                            }
                        }
                        catch (AlreadyClosedException ignore) {
                            log.warn("Tried to reopen the IndexReader, but it threw AlreadyClosedException. Opening a fresh IndexReader.");
                            reader = this.openIndexReader();
                        }
                    } else {
                        reader = this.openIndexReader();
                    }
                }
                this.oldReader = reader;
                return new IndexSearcher(reader);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        private IndexReader openIndexReader() throws IOException {
            if (this.useNRT()) {
                return IndexReader.open((IndexWriter)((Writer)DefaultIndexEngine.this.writerReference.get(Index.UpdateMode.INTERACTIVE)).getLuceneWriter(), (boolean)true);
            }
            ((Writer)DefaultIndexEngine.this.writerReference.get(Index.UpdateMode.INTERACTIVE)).getLuceneWriter().commit();
            return IndexReader.open((Directory)this.configuration.getDirectory(), (boolean)true);
        }

        private IndexReader reopenIndexReader(IndexReader reader) throws IOException {
            if (this.useNRT()) {
                return reader.reopen(((Writer)DefaultIndexEngine.this.writerReference.get(Index.UpdateMode.INTERACTIVE)).getLuceneWriter(), true);
            }
            return reader.reopen();
        }

        private boolean useNRT() {
            return FlushPolicy.PERIODIC.equals((Object)((Writer)DefaultIndexEngine.this.writerReference.get(Index.UpdateMode.INTERACTIVE)).getFlushPolicy());
        }

        @Override
        public void release() {
            IndexReader reader = this.oldReader;
            if (reader != null) {
                try {
                    reader.close();
                    this.oldReader = null;
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static interface SearcherFactory
    extends Supplier<IndexSearcher> {
        public void release();
    }

    static abstract class ReferenceHolder<T>
    implements Function<Index.UpdateMode, T>,
    Closeable {
        private final ResettableLazyReference<T> reference = new ResettableLazyReference();
        private final Effect<T> resetEffect = new Effect<T>(){

            public void apply(T localReference) {
                try {
                    this.doClose(localReference);
                }
                catch (RuntimeException re) {
                    log.debug("Error closing reference", (Throwable)re);
                }
            }
        };

        ReferenceHolder() {
        }

        final void safeClose(T expected) {
            this.reference.safeReset(expected).foreach(this.resetEffect);
        }

        @Override
        public final void close() {
            this.reference.reset().foreach(this.resetEffect);
        }

        abstract void doClose(T var1);

        public final T get(final Index.UpdateMode mode) {
            while (true) {
                try {
                    return this.open(this.reference.getOrCreate(new Supplier<T>(){

                        public T get() {
                            return this.doCreate(mode);
                        }
                    }));
                }
                catch (DelayCloseable.AlreadyClosedException ace) {
                    log.debug("Already closed", (Throwable)((Object)ace));
                    continue;
                }
                break;
            }
        }

        abstract T doCreate(Index.UpdateMode var1);

        abstract T open(T var1);

        final Option<T> get() {
            return this.reference.get();
        }
    }

    private class DefaultWriterFactory
    implements Function<Index.UpdateMode, Writer> {
        private DefaultWriterFactory() {
        }

        public Writer get(Index.UpdateMode mode) {
            return new WriterWrapper(DefaultIndexEngine.this.configuration, mode, new Supplier<IndexSearcher>(){

                public IndexSearcher get() {
                    return DefaultIndexEngine.this.getSearcher();
                }
            });
        }
    }

    @ThreadSafe
    private static class WriterReference
    extends ReferenceHolder<Writer> {
        private final Function<Index.UpdateMode, Writer> writerFactory;

        WriterReference(@Nonnull Function<Index.UpdateMode, Writer> writerFactory) {
            this.writerFactory = (Function)Assertions.notNull((String)"writerFactory", writerFactory);
        }

        public void commit() {
            Option writerOption = this.get();
            if (writerOption.isDefined()) {
                try {
                    ((Writer)writerOption.get()).commit();
                }
                catch (IllegalStateException ise) {
                    log.error("Hit an exception committing writes to the index; discarding the current writer!", (Throwable)ise);
                    this.safeClose(writerOption.get());
                    throw ise;
                }
            }
        }

        @Override
        Writer doCreate(Index.UpdateMode mode) {
            return (Writer)this.writerFactory.get((Object)mode);
        }

        @Override
        void doClose(Writer writer) {
            writer.close();
        }

        @Override
        Writer open(Writer writer) {
            return writer;
        }
    }

    @ThreadSafe
    private class SearcherReference
    extends ReferenceHolder<DelayCloseSearcher> {
        private final SearcherFactory searcherSupplier;

        SearcherReference(SearcherFactory searcherSupplier) {
            this.searcherSupplier = (SearcherFactory)Assertions.notNull((String)"searcherSupplier", (Object)searcherSupplier);
        }

        @Override
        DelayCloseSearcher doCreate(Index.UpdateMode mode) {
            return new DelayCloseSearcher((IndexSearcher)this.searcherSupplier.get());
        }

        @Override
        DelayCloseSearcher open(DelayCloseSearcher searcher) {
            searcher.open();
            return searcher;
        }

        @Override
        void doClose(DelayCloseSearcher searcher) {
            searcher.closeWhenDone();
        }
    }

    public static enum FlushPolicy {
        NONE{

            @Override
            void commit(WriterReference writer) {
            }
        }
        ,
        FLUSH{

            @Override
            void commit(WriterReference writer) {
                writer.commit();
            }
        }
        ,
        PERIODIC{
            ScheduledExecutorService ex = Executors.newScheduledThreadPool(10, new IndexEngineThreadFactory());
            LoadingCache<WriterReference, ScheduledFuture<?>> executorCache = CacheBuilder.newBuilder().build(new CacheLoader<WriterReference, ScheduledFuture<?>>(){

                public ScheduledFuture<?> load(final @Nonnull WriterReference writer) throws Exception {
                    return ex.schedule(new Runnable(){

                        @Override
                        public void run() {
                            executorCache.invalidate((Object)writer);
                            writer.commit();
                            Counter LuceneIndexCommitInstrument = Instrumentation.pullCounter(InstrumentationName.WRITER_LUCENE_COMMIT);
                            LuceneIndexCommitInstrument.incrementAndGet();
                        }
                    }, ((Writer)writer.get(Index.UpdateMode.INTERACTIVE)).getCommitFrequency(), TimeUnit.MILLISECONDS);
                }
            });

            @Override
            void commit(WriterReference writer) {
                try {
                    this.executorCache.get((Object)writer);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        CLOSE{

            @Override
            @ClusterSafe(value="Indexing")
            synchronized void commit(WriterReference writer) {
                writer.close();
            }
        };


        void perform(Index.Operation operation, WriterReference writer) throws IOException {
            try {
                operation.perform((Writer)writer.get(operation.mode()));
            }
            finally {
                this.commit(writer);
            }
        }

        abstract void commit(WriterReference var1);
    }
}

