/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeItem;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.ChangeItemParser;
import com.atlassian.jira.imports.project.parser.ChangeItemParserImpl;
import com.atlassian.jira.imports.project.transformer.ChangeItemTransformer;
import com.atlassian.jira.imports.project.transformer.ChangeItemTransformerImpl;
import com.atlassian.jira.issue.CustomFieldManager;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeItemPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(ChangeItemPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private ChangeItemTransformer changeItemTransformer;
    private ChangeItemParser changeItemParser;
    private BackupProject backupProject;
    private CustomFieldManager customFieldManager;

    public ChangeItemPersisterHandler(ProjectImportPersister projectImportPersister, BackupProject backupProject, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, CustomFieldManager customFieldManager, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupProject = backupProject;
        this.customFieldManager = customFieldManager;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("ChangeItem".equals(entityName)) {
            final ExternalChangeItem oldChangeItem = this.getChangeItemParser().parse(attributes);
            final ExternalChangeItem newChangeItem = this.getChangeItemTransformer().transform(this.projectImportMapper, oldChangeItem);
            if (newChangeItem.getChangeGroupId() != null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        Long changeItemId = ChangeItemPersisterHandler.this.projectImportPersister.createEntity(ChangeItemPersisterHandler.this.getChangeItemParser().getEntityRepresentation(newChangeItem));
                        if (changeItemId == null) {
                            ChangeItemPersisterHandler.this.projectImportResults.addError(ChangeItemPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.change.item.error", oldChangeItem.getId(), oldChangeItem.getChangeGroupId()));
                        }
                    }
                });
            } else {
                log.warn("Not creating change item with id '" + oldChangeItem.getId() + "' for backup change group with id '" + oldChangeItem.getChangeGroupId() + "', the change group has not been mapped in the new system.");
            }
        }
    }

    ChangeItemTransformer getChangeItemTransformer() {
        if (this.changeItemTransformer == null) {
            String mappedProjectId = this.projectImportMapper.getProjectMapper().getMappedId(this.backupProject.getProject().getId());
            this.changeItemTransformer = new ChangeItemTransformerImpl(mappedProjectId, this.customFieldManager);
        }
        return this.changeItemTransformer;
    }

    ChangeItemParser getChangeItemParser() {
        if (this.changeItemParser == null) {
            this.changeItemParser = new ChangeItemParserImpl();
        }
        return this.changeItemParser;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

