/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.ValidationMessage;
import com.atlassian.jira.util.MessageSet;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MappingResult
implements Serializable {
    private static final long serialVersionUID = -1301693049478752957L;
    private MessageSet issueTypeMessageSet;
    private MessageSet customFieldMessageSet;
    private MessageSet priorityMessageSet;
    private MessageSet resolutionMessageSet;
    private MessageSet statusMessageSet;
    private MessageSet projectRoleMessageSet;
    private MessageSet groupMessageSet;
    private MessageSet issueLinkTypeMessageSet;
    private MessageSet fileAttachmentMessageSet;
    private MessageSet userMessageSet;
    private MessageSet projectRoleActorMessageSet;
    private MessageSet issueSecurityLevelMessageSet;
    private Map<String, MessageSet> customFieldValueMessageSets = new HashMap<String, MessageSet>();
    private List<ValidationMessage> systemFieldsMessageList;
    private List<ValidationMessage> customFieldsMessageList;
    private List<ValidationMessage> pluginMessageList = ImmutableList.of();

    public boolean canImport() {
        return this.messageListIsValid(this.systemFieldsMessageList) && this.messageListIsValid(this.customFieldsMessageList) && this.messageListIsValid(this.pluginMessageList);
    }

    public boolean hasAnyCustomFieldValueErrors() {
        for (MessageSet messageSet : this.customFieldValueMessageSets.values()) {
            if (!messageSet.hasAnyErrors()) continue;
            return true;
        }
        return false;
    }

    public MessageSet getIssueTypeMessageSet() {
        return this.issueTypeMessageSet;
    }

    public void setIssueTypeMessageSet(MessageSet issueTypeMessageSet) {
        this.issueTypeMessageSet = issueTypeMessageSet;
    }

    public MessageSet getCustomFieldMessageSet() {
        return this.customFieldMessageSet;
    }

    public void setCustomFieldMessageSet(MessageSet customFieldMessageSet) {
        this.customFieldMessageSet = customFieldMessageSet;
    }

    public MessageSet getPriorityMessageSet() {
        return this.priorityMessageSet;
    }

    public void setPriorityMessageSet(MessageSet priorityMessageSet) {
        this.priorityMessageSet = priorityMessageSet;
    }

    public MessageSet getResolutionMessageSet() {
        return this.resolutionMessageSet;
    }

    public void setResolutionMessageSet(MessageSet resolutionMessageSet) {
        this.resolutionMessageSet = resolutionMessageSet;
    }

    public MessageSet getStatusMessageSet() {
        return this.statusMessageSet;
    }

    public void setStatusMessageSet(MessageSet statusMessageSet) {
        this.statusMessageSet = statusMessageSet;
    }

    public MessageSet getProjectRoleMessageSet() {
        return this.projectRoleMessageSet;
    }

    public MessageSet getGroupMessageSet() {
        return this.groupMessageSet;
    }

    public void setGroupMessageSet(MessageSet groupMessageSet) {
        this.groupMessageSet = groupMessageSet;
    }

    public MessageSet getIssueLinkTypeMessageSet() {
        return this.issueLinkTypeMessageSet;
    }

    public void setIssueLinkTypeMessageSet(MessageSet issueLinkTypeMessageSet) {
        this.issueLinkTypeMessageSet = issueLinkTypeMessageSet;
    }

    public void setProjectRoleMessageSet(MessageSet projectRoleMessageSet) {
        this.projectRoleMessageSet = projectRoleMessageSet;
    }

    public void setProjectRoleActorMessageSet(MessageSet projectRoleActorMessageSet) {
        this.projectRoleActorMessageSet = projectRoleActorMessageSet;
    }

    public MessageSet getProjectRoleActorMessageSet() {
        return this.projectRoleActorMessageSet;
    }

    public MessageSet getFileAttachmentMessageSet() {
        return this.fileAttachmentMessageSet;
    }

    public void setFileAttachmentMessageSet(MessageSet fileAttachmentMessageSet) {
        this.fileAttachmentMessageSet = fileAttachmentMessageSet;
    }

    public MessageSet getUserMessageSet() {
        return this.userMessageSet;
    }

    public void setUserMessageSet(MessageSet userMessageSet) {
        this.userMessageSet = userMessageSet;
    }

    public MessageSet getIssueSecurityLevelMessageSet() {
        return this.issueSecurityLevelMessageSet;
    }

    public void setIssueSecurityLevelMessageSet(MessageSet issueSecurityLevelMessageSet) {
        this.issueSecurityLevelMessageSet = issueSecurityLevelMessageSet;
    }

    public Map<String, MessageSet> getCustomFieldValueMessageSets() {
        return this.customFieldValueMessageSets;
    }

    public void setCustomFieldValueMessageSets(Map<String, MessageSet> customFieldValueMessageSets) {
        this.customFieldValueMessageSets = customFieldValueMessageSets;
    }

    public List<ValidationMessage> getSystemFieldsMessageList() {
        return this.systemFieldsMessageList;
    }

    public void setSystemFieldsMessageList(List<ValidationMessage> messageList) {
        this.systemFieldsMessageList = messageList;
    }

    public List<ValidationMessage> getCustomFieldsMessageList() {
        return this.customFieldsMessageList;
    }

    public void setCustomFieldsMessageList(List<ValidationMessage> customFieldsMessageList) {
        this.customFieldsMessageList = customFieldsMessageList;
    }

    public List<ValidationMessage> getPluginMessageList() {
        return this.pluginMessageList;
    }

    public void setPluginMessageList(List<ValidationMessage> pluginMessageList) {
        this.pluginMessageList = pluginMessageList;
    }

    private boolean messageListIsValid(List<ValidationMessage> messageList) {
        if (messageList == null) {
            return false;
        }
        for (ValidationMessage validationMessage : messageList) {
            if (validationMessage.isValidated() && !validationMessage.getMessageSet().hasAnyErrors()) continue;
            return false;
        }
        return true;
    }
}

