/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.i18n.BackingI18n;
import com.atlassian.jira.i18n.BackingI18nFactory;
import com.atlassian.jira.plugin.language.TranslationTransform;
import com.atlassian.jira.util.i18n.I18nTranslationMode;
import com.atlassian.jira.util.resourcebundle.ResourceBundleLoader;
import com.atlassian.jira.web.bean.i18n.TranslationStore;
import com.atlassian.jira.web.bean.i18n.TranslationStoreFactory;
import java.util.Locale;

public class BackingI18nFactoryImpl
implements BackingI18nFactory {
    private final TranslationStoreFactory storeFactory;
    private final ResourceBundleLoader resourceLoader;
    private final I18nTranslationMode translationMode;

    public BackingI18nFactoryImpl(TranslationStoreFactory storeFactory, ResourceBundleLoader resourceLoader, I18nTranslationMode translationMode) {
        this.storeFactory = storeFactory;
        this.resourceLoader = resourceLoader.i18n();
        this.translationMode = translationMode;
    }

    @Override
    public BackingI18n create(Locale locale, Iterable<? extends TranslationTransform> translationTransforms) {
        ResourceBundleLoader.LoadResult load = this.resourceLoader.locale(locale).load();
        TranslationStore translationStore = this.storeFactory.createTranslationStore(load.getData());
        return new BackingI18n(locale, this.translationMode, translationTransforms, translationStore);
    }
}

