/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.search;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.worklog.Worklog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueIndexListener
extends AbstractIssueEventListener {
    private static final Logger log = LoggerFactory.getLogger(IssueIndexListener.class);
    public static final String NAME = "Issue Index Listener";

    public void init(Map params) {
    }

    public String[] getAcceptedParams() {
        return new String[0];
    }

    public boolean isInternal() {
        return true;
    }

    public void issueCreated(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueUpdated(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueAssigned(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueResolved(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueClosed(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueCommented(IssueEvent event) {
        IssueIndexListener.reIndex(event, IssueIndexingParams.INDEX_ISSUE_ONLY);
        if (event.getComment() != null) {
            IssueIndexListener.reIndexComment(event.getComment());
        }
    }

    public void issueWorkLogged(IssueEvent event) {
        IssueIndexListener.reIndex(event, IssueIndexingParams.INDEX_ISSUE_ONLY);
        if (event.getWorklog() != null) {
            IssueIndexListener.reIndexWorklog(event.getWorklog());
        }
    }

    public void issueReopened(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueGenericEvent(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueCommentEdited(IssueEvent event) {
        IssueIndexListener.reIndex(event, IssueIndexingParams.INDEX_ISSUE_ONLY);
        if (event.getComment() != null) {
            IssueIndexListener.reIndexComment(event.getComment());
        }
    }

    public void issueCommentDeleted(IssueEvent event) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().withComments().build();
        IssueIndexListener.reIndex(event, issueIndexingParams);
    }

    public void issueWorklogUpdated(IssueEvent event) {
        IssueIndexListener.reIndex(event, IssueIndexingParams.INDEX_ISSUE_ONLY);
        if (event.getWorklog() != null) {
            IssueIndexListener.reIndexWorklog(event.getWorklog());
        }
    }

    public void issueWorklogDeleted(IssueEvent event) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().withWorklogs().build();
        IssueIndexListener.reIndex(event, issueIndexingParams);
    }

    public void issueDeleted(IssueEvent event) {
    }

    public void issueMoved(IssueEvent event) {
        IssueIndexListener.reIndex(event, IssueIndexingParams.INDEX_ALL);
    }

    public void customEvent(IssueEvent event) {
    }

    private static void reIndex(IssueEvent issueEvent, IssueIndexingParams issueIndexingParams) {
        HashSet<Issue> issuesToReindex = new HashSet<Issue>();
        Issue issue = issueEvent.getIssue();
        issuesToReindex.add(issue);
        if (issueEvent.isSubtasksUpdated()) {
            issuesToReindex.addAll(issue.getSubTaskObjects());
        }
        try {
            IssueIndexListener.getIssueIndexManager().reIndexIssueObjects(issuesToReindex, issueIndexingParams);
        }
        catch (Exception issueReindexException) {
            log.error("Error re-indexing changes for issue '" + issue.getKey() + "'", (Throwable)issueReindexException);
        }
    }

    private static void reIndexModifiedIssue(IssueEvent event) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().withChangeHistory().build();
        IssueIndexListener.reIndex(event, issueIndexingParams);
        if (event.getComment() != null) {
            IssueIndexListener.reIndexComment(event.getComment());
        }
    }

    private static void reIndexComment(Comment comment) {
        try {
            IssueIndexListener.getIssueIndexManager().reIndexComments(Collections.singletonList(comment));
        }
        catch (Exception commentReindexException) {
            log.error("Error re-indexing comment '" + comment.getId() + "'", (Throwable)commentReindexException);
        }
    }

    private static void reIndexWorklog(Worklog worklog) {
        try {
            IssueIndexListener.getIssueIndexManager().reIndexWorklogs(Collections.singletonList(worklog));
        }
        catch (Exception worklogReindexException) {
            log.error("Error re-indexing worklog '" + worklog.getId() + "'", (Throwable)worklogReindexException);
        }
    }

    public boolean isUnique() {
        return true;
    }

    private static IssueIndexManager getIssueIndexManager() {
        return (IssueIndexManager)ComponentAccessor.getComponent(IssueIndexManager.class);
    }

    public String getDescription() {
        return this.getI18NBean().getText("admin.listener.issue.index.desc");
    }
}

