/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.listeners.mail.IssueEventMailNotifier;
import com.atlassian.jira.mail.IssueMailQueueItem;
import com.atlassian.jira.mail.IssueMailQueueItemFactory;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.type.NotificationType;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueEventMailNotifierImpl
implements IssueEventMailNotifier {
    private static final Logger log = LoggerFactory.getLogger(IssueEventMailNotifierImpl.class);
    private final NotificationFilterManager notificationFilterManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final TemplateManager templateManager;
    private final IssueMailQueueItemFactory issueMailQueueItemFactory;
    private final MailQueue mailQueue;

    public IssueEventMailNotifierImpl(NotificationFilterManager notificationFilterManager, NotificationSchemeManager notificationSchemeManager, TemplateManager templateManager, IssueMailQueueItemFactory issueMailQueueItemFactory, MailQueue mailQueue) {
        this.notificationFilterManager = notificationFilterManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.templateManager = templateManager;
        this.issueMailQueueItemFactory = issueMailQueueItemFactory;
        this.mailQueue = mailQueue;
    }

    @Override
    @Nonnull
    public Set<NotificationRecipient> generateNotifications(@Nonnull List<SchemeEntity> schemeEntities, @Nonnull IssueEvent issueEvent, @Nonnull Set<NotificationRecipient> initialRecipientsToSkip) {
        HashSet notifiedRecipients = Sets.newHashSet();
        HashSet recipientsToSkip = Sets.newHashSet(initialRecipientsToSkip);
        NotificationFilterContext context = this.notificationFilterManager.makeContextFrom((NotificationReason)JiraNotificationReason.ISSUE_EVENT, issueEvent);
        for (SchemeEntity schemeEntity : schemeEntities) {
            context = this.notificationFilterManager.makeContextFrom(context, NotificationType.from((String)schemeEntity.getType()));
            Set<NotificationRecipient> recipientsNotifiedForSchemeEntity = this.createMailItemsForSchemeEntity(schemeEntity, issueEvent, recipientsToSkip, context);
            notifiedRecipients.addAll(recipientsNotifiedForSchemeEntity);
            recipientsToSkip.addAll(recipientsNotifiedForSchemeEntity);
        }
        return notifiedRecipients;
    }

    private Set<NotificationRecipient> createMailItemsForSchemeEntity(@Nonnull SchemeEntity schemeEntity, @Nonnull IssueEvent issueEvent, @Nonnull Set<NotificationRecipient> recipientsToSkip, @Nonnull NotificationFilterContext context) {
        try {
            Set<NotificationRecipient> recipients = this.getRecipientsToNotify(schemeEntity, issueEvent, context, recipientsToSkip);
            if (!recipients.isEmpty()) {
                this.createAndEnqueue(schemeEntity, issueEvent, recipients);
                return recipients;
            }
        }
        catch (GenericEntityException e) {
            log.error("There was an error accessing the notification scheme for the project: " + issueEvent.getProject().getKey() + ".", (Throwable)e);
        }
        return Collections.emptySet();
    }

    private Set<NotificationRecipient> getRecipientsToNotify(@Nonnull SchemeEntity schemeEntity, @Nonnull IssueEvent issueEvent, @Nonnull NotificationFilterContext context, Set<NotificationRecipient> recipientsToSkip) throws GenericEntityException {
        Set recipients = this.notificationSchemeManager.getRecipients(issueEvent, schemeEntity);
        recipients = Sets.newHashSet(this.notificationFilterManager.recomputeRecipients(recipients, context));
        recipients.removeAll(recipientsToSkip);
        return recipients;
    }

    private void createAndEnqueue(@Nonnull SchemeEntity schemeEntity, @Nonnull IssueEvent issueEvent, Set<NotificationRecipient> recipients) {
        long templateId = this.templateManager.getTemplate(schemeEntity).getId();
        IssueMailQueueItem item = this.issueMailQueueItemFactory.getIssueMailQueueItem(issueEvent, templateId, recipients, schemeEntity.getType());
        this.mailQueue.addItem((MailQueueItem)item);
    }
}

