/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.util.collect.PagedList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PagedListIterator<E>
implements Iterator<List<E>> {
    private final PagedList<E> target;
    private final int size;
    private final int pageSize;
    private int currentPage;
    private int currentListCount;

    PagedListIterator(PagedList<E> target) {
        this.target = target;
        this.size = target.getSize();
        this.pageSize = target.getPageSize();
    }

    @Override
    public boolean hasNext() {
        return this.currentListCount < this.size;
    }

    @Override
    public List<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There are no more pages to iterate over");
        }
        List itemsInPage = this.target.getPage(this.currentPage + 1);
        ++this.currentPage;
        this.currentListCount += this.pageSize;
        return itemsInPage;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

