/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.DashboardItemModuleId;
import com.atlassian.gadgets.DashboardItemModuleIdVisitor;
import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.LocalDashboardItemModuleId;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.spi.DashboardItemStateFactory;
import com.atlassian.jira.component.ComponentAccessor;
import java.net.URI;
import org.ofbiz.core.entity.DelegatorInterface;

public class JiraDashboardItemStateFactoryImpl
implements DashboardItemStateFactory {
    private static final Color DEFAULT_JIRA_DASHBOARD_ITEM_CHROME_COLOR = Color.color1;

    public DashboardItemState createDashboardItemState(DashboardItemModuleId moduleId) {
        return (DashboardItemState)moduleId.accept((DashboardItemModuleIdVisitor)new DashboardItemModuleIdVisitor<DashboardItemState>(){

            public DashboardItemState visit(OpenSocialDashboardItemModuleId openSocialModuleId) {
                return JiraDashboardItemStateFactoryImpl.this.createGadgetState(openSocialModuleId);
            }

            public DashboardItemState visit(LocalDashboardItemModuleId dashboardItemModuleId) {
                return JiraDashboardItemStateFactoryImpl.this.createLocalDashboardState(dashboardItemModuleId);
            }
        });
    }

    public LocalDashboardItemState createLocalDashboardState(LocalDashboardItemModuleId dashboardItemModuleId) {
        return LocalDashboardItemState.builder().gadgetId(this.getNewGadgetId()).dashboardItemModuleId(dashboardItemModuleId).color(DEFAULT_JIRA_DASHBOARD_ITEM_CHROME_COLOR).build();
    }

    public GadgetState createGadgetState(OpenSocialDashboardItemModuleId openSocialDashboardItemModuleId) {
        URI uri = openSocialDashboardItemModuleId.getSpecUri();
        return GadgetState.gadget((GadgetId)this.getNewGadgetId()).specUri(uri).color(DEFAULT_JIRA_DASHBOARD_ITEM_CHROME_COLOR).build();
    }

    private GadgetId getNewGadgetId() {
        Long nextSeqId = ((DelegatorInterface)ComponentAccessor.getComponent(DelegatorInterface.class)).getNextSeqId("PortletConfiguration");
        return GadgetId.valueOf((String)nextSeqId.toString());
    }
}

