/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.index.DefaultIndexEngine;
import com.atlassian.jira.index.LuceneVersion;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;

public interface IndexWriterConfiguration {
    public WriterSettings getInteractiveSettings();

    public WriterSettings getBatchSettings();

    public static class PropertiesAdaptor
    implements IndexWriterConfiguration {
        private final ApplicationProperties properties;
        private final WriterSettings batch = new WriterSettings(){

            @Override
            public int getMaxBufferedDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.batch.maxbuffereddocs", (int)Default.BATCH.getMaxBufferedDocs());
            }

            @Override
            public int getMergeFactor() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.batch.mergefactor", (int)Default.BATCH.getMergeFactor());
            }

            @Override
            public int getMaxMergeDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.batch.maxmergedocs", (int)Default.BATCH.getMaxMergeDocs());
            }

            @Override
            public int getMaxFieldLength() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.maxfieldlength", (int)Default.BATCH.getMaxFieldLength());
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                String policyProperty = properties.getDefaultBackedString("jira.index.commitpolicy");
                DefaultIndexEngine.FlushPolicy commitPolicy = DefaultIndexEngine.FlushPolicy.valueOf(policyProperty);
                return commitPolicy != null ? commitPolicy : Default.BATCH.getFlushPolicy();
            }

            @Override
            public long getCommitFrequency() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.commitfrequency", (int)((int)Default.INTERACTIVE.getCommitFrequency()));
            }
        };
        private final WriterSettings interactive = new WriterSettings(){

            @Override
            public int getMergeFactor() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.interactive.mergefactor", (int)Default.INTERACTIVE.getMergeFactor());
            }

            @Override
            public int getMaxMergeDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.interactive.maxmergedocs", (int)Default.INTERACTIVE.getMaxMergeDocs());
            }

            @Override
            public int getMaxBufferedDocs() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.interactive.maxbuffereddocs", (int)Default.INTERACTIVE.getMaxBufferedDocs());
            }

            @Override
            public int getMaxFieldLength() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.maxfieldlength", (int)Default.INTERACTIVE.getMaxFieldLength());
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                DefaultIndexEngine.FlushPolicy commitPolicy = null;
                String policyProperty = properties.getDefaultBackedString("jira.index.commitpolicy");
                if (policyProperty != null) {
                    commitPolicy = DefaultIndexEngine.FlushPolicy.valueOf(policyProperty);
                }
                return commitPolicy != null ? commitPolicy : DefaultIndexEngine.FlushPolicy.FLUSH;
            }

            @Override
            public long getCommitFrequency() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.commitfrequency", (int)((int)Default.INTERACTIVE.getCommitFrequency()));
            }
        };

        public PropertiesAdaptor(@Nonnull ApplicationProperties properties) {
            this.properties = (ApplicationProperties)Assertions.notNull((String)"properties", (Object)properties);
        }

        @Override
        public WriterSettings getBatchSettings() {
            return this.batch;
        }

        @Override
        public WriterSettings getInteractiveSettings() {
            return this.interactive;
        }
    }

    public static abstract class WriterSettings {
        public IndexWriterConfig getWriterConfiguration(Analyzer analyser) {
            ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
            TieredMergePolicy mergePolicy = new TieredMergePolicy();
            mergePolicy.setExpungeDeletesPctAllowed((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.expungedeletespctallowed", (int)10));
            mergePolicy.setFloorSegmentMB((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.floorsegmentmb", (int)2));
            mergePolicy.setMaxMergedSegmentMB((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.maxmergedsegmentmb", (int)512));
            mergePolicy.setMaxMergeAtOnce(PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.maxmergeatonce", (int)10));
            mergePolicy.setMaxMergeAtOnceExplicit(PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.maxmergeatonceexplicit", (int)30));
            mergePolicy.setNoCFSRatio((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.nocfspct", (int)10) / 100.0);
            mergePolicy.setSegmentsPerTier((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.segmentspertier", (int)10));
            mergePolicy.setUseCompoundFile(PropertiesUtil.getBooleanProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.usecompoundfile", (boolean)true));
            IndexWriterConfig luceneConfig = new IndexWriterConfig(LuceneVersion.get(), analyser);
            luceneConfig.setMergePolicy((MergePolicy)mergePolicy);
            luceneConfig.setMaxBufferedDocs(this.getMaxBufferedDocs());
            return luceneConfig;
        }

        public abstract int getMaxBufferedDocs();

        public abstract int getMergeFactor();

        public abstract int getMaxMergeDocs();

        public abstract int getMaxFieldLength();

        public abstract DefaultIndexEngine.FlushPolicy getFlushPolicy();

        public abstract long getCommitFrequency();
    }

    public static final class Default {
        static final int MAX_FIELD_LENGTH = IndexWriter.DEFAULT_MAX_FIELD_LENGTH;
        public static final WriterSettings BATCH = new WriterSettings(){

            @Override
            public int getMergeFactor() {
                return 50;
            }

            @Override
            public int getMaxMergeDocs() {
                return Integer.MAX_VALUE;
            }

            @Override
            public int getMaxBufferedDocs() {
                return 300;
            }

            @Override
            public int getMaxFieldLength() {
                return MAX_FIELD_LENGTH;
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.FLUSH;
            }

            @Override
            public long getCommitFrequency() {
                return 30000L;
            }
        };
        public static final WriterSettings INTERACTIVE = new WriterSettings(){

            @Override
            public int getMergeFactor() {
                return 4;
            }

            @Override
            public int getMaxMergeDocs() {
                return 5000;
            }

            @Override
            public int getMaxBufferedDocs() {
                return 300;
            }

            @Override
            public int getMaxFieldLength() {
                return MAX_FIELD_LENGTH;
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.FLUSH;
            }

            @Override
            public long getCommitFrequency() {
                return 30000L;
            }
        };
    }
}

