/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.config.feature.FeaturesLoader;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.EnabledDarkFeaturesBuilder;
import com.atlassian.sal.api.user.UserKey;
import java.util.Set;
import java.util.stream.Collectors;

public class BootstrapDarkFeatureManager
implements DarkFeatureManager {
    private final Set<String> coreProperties;

    public BootstrapDarkFeatureManager(FeaturesLoader featuresLoader) {
        this.coreProperties = featuresLoader.loadCoreProperties().entrySet().stream().filter(entry -> Boolean.valueOf(entry.getValue().toString())).map(entry -> entry.getKey().toString()).collect(Collectors.toSet());
    }

    public boolean isFeatureEnabledForAllUsers(String featureKey) {
        return this.coreProperties.contains(featureKey);
    }

    public boolean isFeatureEnabledForCurrentUser(String featureKey) {
        return this.isFeatureEnabledForAllUsers(featureKey);
    }

    public boolean isFeatureEnabledForUser(UserKey userKey, String featureKey) {
        return this.isFeatureEnabledForAllUsers(featureKey);
    }

    public boolean canManageFeaturesForAllUsers() {
        return false;
    }

    public void enableFeatureForAllUsers(String s) {
        throw new UnsupportedOperationException("This operation is not supported during setup");
    }

    public void disableFeatureForAllUsers(String s) {
        throw new UnsupportedOperationException("This operation is not supported during setup");
    }

    public void enableFeatureForCurrentUser(String s) {
        throw new UnsupportedOperationException("This operation is not supported during setup");
    }

    public void enableFeatureForUser(UserKey userKey, String s) {
        throw new UnsupportedOperationException("This operation is not supported during setup");
    }

    public void disableFeatureForCurrentUser(String s) {
        throw new UnsupportedOperationException("This operation is not supported during setup");
    }

    public void disableFeatureForUser(UserKey userKey, String s) {
        throw new UnsupportedOperationException("This operation is not supported during setup");
    }

    public EnabledDarkFeatures getFeaturesEnabledForAllUsers() {
        return new EnabledDarkFeaturesBuilder().unmodifiableFeaturesEnabledForAllUsers(this.coreProperties).build();
    }

    public EnabledDarkFeatures getFeaturesEnabledForCurrentUser() {
        return this.getFeaturesEnabledForAllUsers();
    }

    public EnabledDarkFeatures getFeaturesEnabledForUser(UserKey userKey) {
        return this.getFeaturesEnabledForAllUsers();
    }
}

